/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.log;

import com.genesyslab.platform.commons.log.AbstractLogger;
import com.genesyslab.platform.commons.log.ILogger;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleLoggerImpl
extends AbstractLogger {
    private final String name;
    private final PrintStream printStream;
    private int level;
    private static final DateFormat timeFormatter = SimpleDateFormat.getTimeInstance(2);

    SimpleLoggerImpl(String name, PrintStream stream, int level) {
        this.name = name;
        this.printStream = stream;
        this.level = level;
    }

    @Override
    public boolean isDebug() {
        return this.level <= AbstractLogger.Level.DEBUG.ordinal();
    }

    @Override
    public boolean isInfo() {
        return this.level <= AbstractLogger.Level.INFO.ordinal();
    }

    @Override
    public boolean isError() {
        return this.level <= AbstractLogger.Level.ERROR.ordinal();
    }

    @Override
    public boolean isFatalError() {
        return this.level <= AbstractLogger.Level.FATAL_ERROR.ordinal();
    }

    @Override
    public boolean isWarn() {
        return this.level <= AbstractLogger.Level.WARN.ordinal();
    }

    @Override
    public ILogger createChildLogger(String name) {
        return new SimpleLoggerImpl(this.name + "." + name, this.printStream, this.level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void log(Object message, Throwable e, AbstractLogger.Level level) {
        StringBuilder sb = new StringBuilder();
        sb.append(timeFormatter.format(new Date())).append(' ').append(level).append(' ').append(this.name).append(" [").append(Thread.currentThread().getName()).append("] ").append(message);
        if (e != null) {
            PrintStream printStream = this.printStream;
            synchronized (printStream) {
                this.printStream.println(sb);
                e.printStackTrace(this.printStream);
            }
        } else {
            this.printStream.println(sb);
        }
    }

    @Override
    protected void logArgs(String message, Object args, AbstractLogger.Level level) {
        this.log(SimpleLoggerImpl.formatMessage(message, args), null, level);
    }
}

