/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.threading;

import com.genesyslab.platform.commons.management.HeartbeatCounterException;
import com.genesyslab.platform.commons.management.PSDKMBeanBase;
import com.genesyslab.platform.commons.threading.ThreadHeartbeatCounterMBean;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadHeartbeatCounter
extends PSDKMBeanBase
implements ThreadHeartbeatCounterMBean {
    private long threadOSID = -1L;
    private int threadClass;
    private boolean active = false;
    private int heartbeatCounter;
    private static final SecureRandom random = new SecureRandom();
    private static final AtomicInteger uniqIDGen = new AtomicInteger(0);

    private ThreadHeartbeatCounter(String threadLogicalName, int threadClass) {
        super("ThreadHeartbeatMonitor", threadLogicalName, uniqIDGen.incrementAndGet());
        if (threadLogicalName == null || threadLogicalName.length() == 0) {
            throw new IllegalArgumentException("ThreadLogicName can't be empty");
        }
        this.heartbeatCounter = Math.abs(random.nextInt());
        this.setThreadClass(threadClass);
        this.doRegisterMBean();
    }

    public static ThreadHeartbeatCounter createThreadHeartbeatCounter(String threadLogicalName, int threadClass) {
        return new ThreadHeartbeatCounter(threadLogicalName, threadClass);
    }

    @Override
    public synchronized void initialize() {
        if (this.threadOSID >= 0L) {
            throw new HeartbeatCounterException("Thread has already been initialized for heartbeat");
        }
        this.threadOSID = Thread.currentThread().getId();
        this.setActive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unregister() {
        if (this.threadOSID < 0L) {
            throw new HeartbeatCounterException("Thread is not registered for heartbeat");
        }
        try {
            super.unregister();
        }
        finally {
            this.setActive(false);
            this.threadOSID = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forceUnregister() {
        try {
            super.unregister();
        }
        finally {
            this.setActive(false);
            this.threadOSID = -1L;
        }
    }

    @Override
    public long getThreadSystemId() {
        return this.threadOSID;
    }

    @Override
    public String getLogicalName() {
        return this.getMBeanName();
    }

    @Override
    public int getThreadClass() {
        return this.threadClass;
    }

    @Override
    public synchronized void setThreadClass(int newThreadClass) {
        this.threadClass = newThreadClass;
    }

    @Override
    public int getHeartbeatCounter() {
        return this.heartbeatCounter;
    }

    @Override
    public synchronized void setActive(boolean isActive) {
        if (isActive && this.threadOSID < 0L) {
            throw new HeartbeatCounterException("Thread os id has not been initialized");
        }
        this.active = isActive;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public synchronized void alive() {
        if (this.threadOSID < 0L) {
            throw new HeartbeatCounterException("Thread has not been initialized for heartbeat");
        }
        if (this.threadOSID != Thread.currentThread().getId()) {
            throw new IllegalAccessError("Thread alive call must be done by monitored thread by itself");
        }
        ++this.heartbeatCounter;
    }
}

