/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeConverter {
    private final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private final String LOCAL_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private final String DATE_WITH_MILLISECONDS_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("UTC");
    private final SimpleDateFormat localDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final SimpleDateFormat dateFormat_parse = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final SimpleDateFormat dateFormatWithMS_parse = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final SimpleDateFormat dateFormat_parse2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final SimpleDateFormat dateFormatWithMS_parse2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final SimpleDateFormat dateFormat_toString = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final SimpleDateFormat dateFormatWithMS_toString = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final DateTimeConverter instance = new DateTimeConverter();

    public DateTimeConverter() {
        this.dateFormat_parse.setTimeZone(this.GMT_TIMEZONE);
        this.dateFormatWithMS_parse.setTimeZone(this.GMT_TIMEZONE);
        this.dateFormat_parse2.setTimeZone(this.GMT_TIMEZONE);
        this.dateFormatWithMS_parse2.setTimeZone(this.GMT_TIMEZONE);
        this.dateFormat_toString.setTimeZone(this.GMT_TIMEZONE);
        this.dateFormatWithMS_toString.setTimeZone(this.GMT_TIMEZONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseWithoutMillis(String dateStr) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.dateFormat_parse;
        synchronized (simpleDateFormat) {
            try {
                return this.dateFormat_parse.parse(dateStr);
            }
            catch (ParseException ex) {
                return this.dateFormatWithMS_parse.parse(dateStr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseWithMillis(String dateStr) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.dateFormat_parse2;
        synchronized (simpleDateFormat) {
            try {
                return this.dateFormatWithMS_parse2.parse(dateStr);
            }
            catch (ParseException ex) {
                return this.dateFormat_parse2.parse(dateStr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringWithoutMillis(Date value) {
        SimpleDateFormat simpleDateFormat = this.dateFormat_toString;
        synchronized (simpleDateFormat) {
            return this.dateFormat_toString.format(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringWithMillis(Date value) {
        SimpleDateFormat simpleDateFormat = this.dateFormatWithMS_toString;
        synchronized (simpleDateFormat) {
            return this.dateFormatWithMS_toString.format(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toLocalStringWithoutMS(Date value) {
        SimpleDateFormat simpleDateFormat = this.localDateFormat;
        synchronized (simpleDateFormat) {
            return this.localDateFormat.format(value);
        }
    }

    public static Date parse(String dateStr) throws ParseException {
        return instance.parseWithoutMillis(dateStr);
    }

    public static String toString(Date value) {
        return instance.toStringWithoutMillis(value);
    }

    public static String toLocalString(Date value) {
        return instance.toLocalStringWithoutMS(value);
    }
}

