/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.threading.SingleThreadInvoker;
import com.genesyslab.platform.commons.timer.impl.SchedulerImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class PSDKRuntime {
    private static final ILogger log = Log.getLogger(PSDKRuntime.class);

    private PSDKRuntime() {
    }

    public static void awaitTermination() throws InterruptedException {
        new TerminationMonitor().awaitTermination();
    }

    public static void awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        boolean timeoutFlag;
        boolean bl = timeoutFlag = !new TerminationMonitor().awaitTermination(timeout, timeUnit);
        if (timeoutFlag) {
            PSDKRuntime.logInfoState("Timeout " + timeout + " " + timeUnit.name() + ". PSDK activity isn't terminated");
            throw new TimeoutException();
        }
    }

    private static void logState(String title) {
        if (log.isDebug()) {
            log.debug((Object)PSDKRuntime.generateStateInfo(title));
        } else if (log.isInfo()) {
            log.info((Object)title);
        }
    }

    private static void logInfoState(String title) {
        if (log.isInfo()) {
            log.info((Object)PSDKRuntime.generateStateInfo(title));
        }
    }

    private static String generateStateInfo(String title) {
        try {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (title != null) {
                sw.append(title + "\n");
            }
            sw.append(SchedulerImpl.getStateInfo());
            sw.append(SingleThreadInvoker.getStateInfo());
            Exception stacktracePrinter = new Exception(){

                @Override
                public String toString() {
                    return "";
                }
            };
            sw.append("Threads:\n");
            for (Thread t : allStackTraces.keySet()) {
                sw.append("   ");
                sw.append(t.toString());
                StackTraceElement[] stack = allStackTraces.get(t);
                if (stack != null) {
                    stacktracePrinter.setStackTrace(stack);
                    stacktracePrinter.printStackTrace(pw);
                }
                sw.append("\n");
            }
            return sw.toString();
        }
        catch (Throwable ex) {
            if (log.isInfo()) {
                log.info((Object)"There is no permissions to log threads dump");
            }
            return title;
        }
    }

    private static class TerminationMonitor
    implements Runnable {
        private final AtomicReference<Thread> thread1 = new AtomicReference();
        private final AtomicReference<Thread> thread2 = new AtomicReference();
        private final CountDownLatch latch = new CountDownLatch(2);

        public TerminationMonitor() {
            if (log.isInfo()) {
                log.info((Object)"Waiting for PSDK activity termination");
            }
            SingleThreadInvoker.awaitTermination((Runnable)this);
            SchedulerImpl.awaitTermination(this);
        }

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            if (!this.thread1.compareAndSet(null, currentThread)) {
                this.thread2.compareAndSet(null, currentThread);
            }
            this.latch.countDown();
        }

        private void awaitTermination() throws InterruptedException {
            long time0 = System.currentTimeMillis();
            while (!this.latch.await(30000L, TimeUnit.MILLISECONDS)) {
                PSDKRuntime.logState("Waiting for PSDK activity termination (elapsed time " + (System.currentTimeMillis() - time0) + " ms)");
            }
            Thread currentThread = Thread.currentThread();
            Thread t = this.thread1.get();
            if (t != null) {
                if (t != currentThread) {
                    if (log.isInfo()) {
                        log.info((Object)("Waiting for thread \"" + t.getName() + "\" death"));
                    }
                    t.join();
                }
                if ((t = this.thread2.get()) != null && t != currentThread) {
                    if (log.isInfo()) {
                        log.info((Object)("Waiting for thread \"" + t.getName() + "\" death"));
                    }
                    t.join();
                }
            }
            PSDKRuntime.logState("PSDK activity was terminated ( elapsed time " + (System.currentTimeMillis() - time0) + " ms)");
        }

        private boolean awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException {
            long time0 = System.currentTimeMillis();
            long timeoutInMillis = timeUnit.toMillis(timeout);
            long timeTo = time0 + timeoutInMillis;
            boolean bigDelay = false;
            while (true) {
                long currentTime;
                if ((timeoutInMillis = Math.min(30000L, timeTo - (currentTime = System.currentTimeMillis()))) <= 0L) {
                    return false;
                }
                if (bigDelay) {
                    PSDKRuntime.logState("Waiting for PSDK activity termination (elapsed time " + (currentTime - time0) + " ms)");
                }
                if (this.latch.await(timeoutInMillis, TimeUnit.MILLISECONDS)) break;
                bigDelay = true;
            }
            Thread currentThread = Thread.currentThread();
            Thread t = this.thread1.get();
            if (t != null) {
                if (t != currentThread) {
                    timeoutInMillis = timeTo - System.currentTimeMillis();
                    if (timeoutInMillis <= 0L) {
                        return false;
                    }
                    if (log.isInfo()) {
                        log.info((Object)("Waiting for thread \"" + t.getName()));
                    }
                    t.join(timeoutInMillis);
                }
                if ((t = this.thread2.get()) != null && t != currentThread) {
                    timeoutInMillis = timeTo - System.currentTimeMillis();
                    if (timeoutInMillis <= 0L) {
                        return false;
                    }
                    log.info((Object)("Waiting for thread \"" + t.getName()));
                    t.join(timeoutInMillis);
                }
            }
            PSDKRuntime.logState("PSDK activity was terminated ( elapsed time " + (System.currentTimeMillis() - time0) + " ms)");
            return true;
        }

        public String toString() {
            return "PSDKRuntime.awaitTermination";
        }
    }
}

