/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.xml;

import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlUtil {
    private XmlUtil() {
    }

    public static Element getFirstChild(Element parent) {
        Node node;
        for (node = parent.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getFirstChild(Element parent, String childNodeName) {
        Node node;
        for (node = parent.getFirstChild(); !(node == null || node.getNodeType() == 1 && childNodeName.equals(node.getNodeName())); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getNextSibling(Element elem) {
        Node node;
        for (node = elem.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static String getElementText(Element elem) {
        StringBuffer buf = new StringBuffer();
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            buf.append(node.getNodeValue());
        }
        return buf.toString();
    }

    public static void appendText(Element element, String stringValue) {
        Document nodeFactory = element.getOwnerDocument();
        element.appendChild(nodeFactory.createTextNode(stringValue));
    }

    public static DOMSource asDomSource(Source source) throws TransformerException {
        if (source instanceof DOMSource) {
            return (DOMSource)source;
        }
        DOMResult result = new DOMResult();
        XmlFactories.newTransformer().transform(source, result);
        Node node = result.getNode();
        return new DOMSource(node);
    }

    public static Document createDocument() throws ParserConfigurationException {
        return XmlFactories.newDocumentBuilder().newDocument();
    }

    public static void setElementAttribute(Element elem, String attrName, String attrValue) {
        if (attrValue == null) {
            attrValue = "";
        }
        elem.setAttribute(attrName, attrValue);
    }

    public static void outputDocument(Document doc, OutputStream out) throws TransformerException {
        Transformer transformer = XmlFactories.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(doc), new StreamResult(out));
    }
}

