/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.eservices.gdpr;

import com.genesyslab.eservices.gdpr.PsdkClient;
import com.genesyslab.platform.commons.protocol.ChannelNotClosedException;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.contacts.protocol.contactserver.AttributesHeader;
import com.genesyslab.platform.contacts.protocol.contactserver.AttributesInfo;
import com.genesyslab.platform.contacts.protocol.contactserver.AttributesList;
import com.genesyslab.platform.contacts.protocol.contactserver.events.EventDelete;
import com.genesyslab.platform.contacts.protocol.contactserver.events.EventGetAttributes;
import com.genesyslab.platform.contacts.protocol.contactserver.requests.RequestDelete;
import com.genesyslab.platform.contacts.protocol.contactserver.requests.RequestGetAttributes;
import java.util.Iterator;

public class ContactDeleter
extends PsdkClient {
    private static int contactsFound = 0;
    private static final String CONFIRM_ARG = "-confirm";
    private static boolean CONFIRMED = false;

    private static boolean getCommitMode(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase(CONFIRM_ARG)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                ContactDeleter.log("Please provide the ids of the contact to delete or identify parameters");
            }
            ContactDeleter contactDeleter = new ContactDeleter();
            String searchedContact = PsdkClient.getUnNamedArgument(args, CONFIRM_ARG);
            if (searchedContact == null) {
                PsdkClient.log("Please provide the ids of the contact to work with or identify parameters as json string");
                return;
            }
            contactDeleter.connect();
            String[] ids = contactDeleter.getIds(searchedContact);
            CONFIRMED = ContactDeleter.getCommitMode(args);
            Integer tenantId = PsdkClient.getTenantId(searchedContact, TENANT_ID);
            ContactDeleter.log("TenantId is " + tenantId);
            for (String contactId : ids) {
                contactDeleter.deleteContact(contactId, tenantId);
            }
            if (!CONFIRMED) {
                switch (contactsFound) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ContactDeleter.log("Run again with the argument \"-confirm\" to delete this contact and its interactions");
                        break;
                    }
                    default: {
                        ContactDeleter.log("Run again with the argument \"-confirm\" to delete these " + contactsFound + " contacts and their interactions");
                    }
                }
            }
            contactDeleter.disconnect();
            PsdkClient.log("Done");
        }
        catch (Throwable t) {
            ContactDeleter.log(t.getMessage());
            t.printStackTrace(System.out);
        }
    }

    private void deleteContact(String contactId, Integer tenantId) throws ChannelNotClosedException, ProtocolException, InterruptedException {
        if (CONFIRMED) {
            ContactDeleter.log("Delete Contact '" + contactId + "'");
            RequestDelete requestDelete = RequestDelete.create();
            requestDelete.setContactId(contactId);
            Message msg = this.request((Message)requestDelete, 5L * TIMEOUT_LONG);
            if (msg instanceof EventDelete) {
                ContactDeleter.log("Contact '" + contactId + "' and linked interactions successfully deleted");
            } else {
                if (!ContactDeleter.verbose()) {
                    ContactDeleter.log(msg.toString());
                }
                ContactDeleter.log("Failed to delete Contact '" + contactId + "'");
            }
        } else {
            ContactDeleter.log("Read Contact '" + contactId + "' attributes");
            RequestGetAttributes requestGetAttributes = new RequestGetAttributes();
            requestGetAttributes.setContactId(contactId);
            Message message = this.request((Message)requestGetAttributes);
            if (message instanceof EventGetAttributes) {
                ++contactsFound;
                StringBuilder attributes = new StringBuilder("Contact '").append(contactId).append("' attributes are ");
                AttributesList attributesList = ((EventGetAttributes)message).getAttributes();
                for (AttributesHeader attributesHeader : attributesList) {
                    attributes.append(attributesHeader.getAttrName()).append(": [");
                    Iterator it = attributesHeader.getAttributesInfoList().iterator();
                    while (it.hasNext()) {
                        AttributesInfo attributesInfo = (AttributesInfo)it.next();
                        attributes.append(attributesInfo.getAttrValue().toString());
                        if (!it.hasNext()) continue;
                        attributes.append(", ");
                    }
                    attributes.append("]  ");
                }
                ContactDeleter.log(attributes.toString());
            } else {
                if (!ContactDeleter.verbose()) {
                    ContactDeleter.log(message.toString());
                }
                ContactDeleter.log("Did not find contact with id='" + contactId + "'");
            }
            this.countInteractionsForContactId(contactId, tenantId);
        }
    }
}

