/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.eservices.gdpr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.genesyslab.eservices.gdpr.PsdkClient;
import com.genesyslab.platform.commons.protocol.ChannelNotClosedException;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.contacts.protocol.contactserver.Attachment;
import com.genesyslab.platform.contacts.protocol.contactserver.AttachmentList;
import com.genesyslab.platform.contacts.protocol.contactserver.DataSourceType;
import com.genesyslab.platform.contacts.protocol.contactserver.InteractionData;
import com.genesyslab.platform.contacts.protocol.contactserver.InteractionDataList;
import com.genesyslab.platform.contacts.protocol.contactserver.SearchCriteriaCollection;
import com.genesyslab.platform.contacts.protocol.contactserver.events.EventCountInteractions;
import com.genesyslab.platform.contacts.protocol.contactserver.events.EventError;
import com.genesyslab.platform.contacts.protocol.contactserver.events.EventGetDocument;
import com.genesyslab.platform.contacts.protocol.contactserver.events.EventGetInteractionContent;
import com.genesyslab.platform.contacts.protocol.contactserver.events.EventInteractionListGet;
import com.genesyslab.platform.contacts.protocol.contactserver.events.EventInteractionListGetNextPage;
import com.genesyslab.platform.contacts.protocol.contactserver.requests.RequestCountInteractions;
import com.genesyslab.platform.contacts.protocol.contactserver.requests.RequestGetAttributes;
import com.genesyslab.platform.contacts.protocol.contactserver.requests.RequestGetDocument;
import com.genesyslab.platform.contacts.protocol.contactserver.requests.RequestGetInteractionContent;
import com.genesyslab.platform.contacts.protocol.contactserver.requests.RequestInteractionListGet;
import com.genesyslab.platform.contacts.protocol.contactserver.requests.RequestInteractionListGetNextPage;
import com.genesyslab.platform.contacts.protocol.contactserver.requests.RequestInteractionListRelease;
import com.genesyslab.platform.json.serializer.PsdkJsonSerializer;
import com.genesyslab.platform.json.serializer.PsdkSerializationException;
import com.google.common.io.BaseEncoding;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InteractionExportManager {
    private static String DOT_JSON = ".json";
    private static final String COUNT_ARG = "-count";
    private static final Integer MAX_PAGE_SIZE = Integer.getInteger("pageSize", 20);
    private static final String EXPORT_PATH = System.getProperty("PATH", ".");
    private static final Path PATH = Paths.get(EXPORT_PATH, new String[0]);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private PsdkJsonSerializer serializer = PsdkJsonSerializer.createContactServerSerializer();
    private final PsdkClient client;

    InteractionExportManager(PsdkClient client) {
        this.client = client;
    }

    public static void main(String[] args) {
        try {
            PsdkClient.log("Starting interaction export");
            PsdkClient.log("Export path is " + PATH);
            String searchedContact = PsdkClient.getUnNamedArgument(args, COUNT_ARG);
            if (searchedContact == null) {
                PsdkClient.log("Please provide the ids of the contact to work with or identify parameters as json string");
                return;
            }
            Integer tenantId = PsdkClient.getTenantId(searchedContact, PsdkClient.TENANT_ID);
            PsdkClient.log("TenantId is " + tenantId);
            InteractionExportManager interactionExportManager = new InteractionExportManager(new PsdkClient());
            interactionExportManager.connect();
            String[] ids = interactionExportManager.getIds(searchedContact);
            ExportMode mode = InteractionExportManager.getWorkMode(args);
            switch (mode) {
                case COUNT_ONLY: {
                    String contacts = ids.length > 1 ? " contacts" : " contact";
                    PsdkClient.log(ids.length + contacts + " involved");
                    for (String contactId : ids) {
                        interactionExportManager.countInteractionsForContactId(contactId, tenantId);
                    }
                    break;
                }
                case EXPORT: {
                    InteractionExportManager.checkOrCreateDirectory(InteractionExportManager.getRootPath());
                    for (String contactId : ids) {
                        interactionExportManager.exportInteractionsForContact(contactId, tenantId);
                    }
                    break;
                }
            }
            interactionExportManager.disconnect();
            PsdkClient.log("Done");
        }
        catch (Throwable t) {
            PsdkClient.log(t.getMessage());
            t.printStackTrace(System.out);
        }
    }

    private String[] getIds(String id) throws ProtocolException, InterruptedException {
        return this.client.getIds(id);
    }

    private void connect() throws InterruptedException, ProtocolException {
        this.client.connect();
    }

    private void disconnect() throws InterruptedException, ProtocolException {
        this.client.disconnect();
    }

    private static ExportMode getWorkMode(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase(COUNT_ARG)) continue;
            return ExportMode.COUNT_ONLY;
        }
        return ExportMode.EXPORT;
    }

    private static void checkOrCreateDirectory(String dir) {
        File file = new File(dir);
        if (!file.isDirectory()) {
            PsdkClient.log("Creating directory " + dir);
            file.mkdirs();
        } else {
            PsdkClient.log("Directory exists: " + dir);
        }
    }

    private static String getRootPath() {
        Path root = PATH.toAbsolutePath();
        return root.toString();
    }

    private String getScrollId(EventInteractionListGet message) {
        return message.getScrollId();
    }

    private boolean hasNext(Message message) {
        Object hasNext = message.getMessageAttribute("HasNext");
        return hasNext instanceof Boolean ? (Boolean)hasNext : false;
    }

    private void addBinaryToDocument(JsonNode jsonObject, Map<String, String> binaryMap) {
        JsonNode attachments = jsonObject.get("attachments");
        if (binaryMap != null && attachments != null && attachments.isArray()) {
            for (JsonNode node : attachments) {
                JsonNode docId = node.get("documentId");
                if (docId == null) continue;
                String content = binaryMap.get(docId.asText());
                ((ObjectNode)node).put("binary", content);
            }
        }
    }

    String sanitizeJson(String json, Map<String, String> binaryMap) throws IOException {
        JsonNode interactionAttributesNode;
        JsonNode jsonObject = objectMapper.readTree(json);
        ((ObjectNode)jsonObject).remove("referenceId");
        ((ObjectNode)jsonObject).remove("messageName");
        JsonNode entityAttributesNode = jsonObject.get("entityAttributes");
        if (entityAttributesNode != null) {
            ((ObjectNode)entityAttributesNode).remove("$class");
        }
        if ((interactionAttributesNode = jsonObject.get("interactionAttributes")) != null) {
            ((ObjectNode)interactionAttributesNode).remove("theComment");
        }
        this.addBinaryToDocument(jsonObject, binaryMap);
        String filteredJson = objectMapper.writeValueAsString((Object)jsonObject);
        if (PsdkClient.verbose()) {
            PsdkClient.log("json=" + filteredJson);
        }
        return filteredJson;
    }

    private String serializeToJsonString(Message message, HashMap<String, String> binaryMap) throws PsdkSerializationException, IOException {
        String json = this.serializer.serialize((Object)message);
        return this.sanitizeJson(json, binaryMap);
    }

    private HashMap<String, String> getBinariesForDocumentsInInteraction(AttachmentList attachments, String interactionId, DataSourceType source) throws InterruptedException, ProtocolException {
        HashMap<String, String> mapBinaryWithDocIds = new HashMap<String, String>();
        if (attachments == null) {
            return mapBinaryWithDocIds;
        }
        for (Attachment documentMetadata : attachments) {
            RequestGetDocument requestDocument = RequestGetDocument.create();
            requestDocument.setDataSource(source);
            requestDocument.setDocumentId(documentMetadata.getDocumentId());
            requestDocument.setIncludeBinaryContent(Boolean.valueOf(true));
            Message documentResponse = this.client.request((Message)requestDocument);
            switch (documentResponse.messageId()) {
                case 100: {
                    PsdkClient.log("Error to get content for document Id " + documentMetadata.getDocumentId() + " (interaction Id '" + interactionId + "')");
                    this.logUcsError(documentResponse);
                    break;
                }
                case 125: {
                    PsdkClient.log("Retrieved binary content for document Id " + documentMetadata.getDocumentId() + " (interaction Id '" + interactionId + "')");
                    EventGetDocument content = (EventGetDocument)documentResponse;
                    String base64 = content.getContent() != null ? BaseEncoding.base64().encode(content.getContent()) : null;
                    mapBinaryWithDocIds.put(documentMetadata.getDocumentId(), base64);
                }
            }
        }
        return mapBinaryWithDocIds;
    }

    private String retrieveInteractionContentAsJson(String interactionId, DataSourceType source) throws InterruptedException, ProtocolException, IOException, PsdkSerializationException {
        RequestGetInteractionContent requestInteractionContent = RequestGetInteractionContent.create();
        requestInteractionContent.setInteractionId(interactionId);
        requestInteractionContent.setDataSource(source);
        requestInteractionContent.setIncludeBinaryContent(Boolean.valueOf(true));
        requestInteractionContent.setIncludeAttachments(Boolean.valueOf(true));
        Message interactionContentResponse = this.client.request((Message)requestInteractionContent);
        switch (interactionContentResponse.messageId()) {
            case 100: {
                PsdkClient.log("Error to get content interaction for interaction Id '" + interactionId + "'");
                this.logUcsError(interactionContentResponse);
                return null;
            }
            case 121: {
                EventGetInteractionContent eventGetInteractionContent = (EventGetInteractionContent)interactionContentResponse;
                if (PsdkClient.verbose()) {
                    PsdkClient.log("Processed interaction Id " + interactionId);
                }
                AttachmentList attachments = eventGetInteractionContent.getAttachments();
                HashMap<String, String> mapBinaryWithDocIds = this.getBinariesForDocumentsInInteraction(attachments, interactionId, source);
                return this.serializeToJsonString((Message)eventGetInteractionContent, mapBinaryWithDocIds);
            }
        }
        PsdkClient.log("Received unexpected message " + interactionContentResponse.messageName());
        return null;
    }

    private void persistInteractions(InteractionDataList interactionDataList, DataSourceType source, DataOutputStream outputStream) throws ProtocolException, PsdkSerializationException, IOException, InterruptedException {
        if (interactionDataList == null) {
            return;
        }
        Iterator it = interactionDataList.iterator();
        while (it.hasNext()) {
            InteractionData interactionData = (InteractionData)it.next();
            String interactionContent = this.retrieveInteractionContentAsJson(interactionData.getId(), source);
            if (interactionContent == null) continue;
            outputStream.writeBytes(interactionContent);
            if (!it.hasNext()) continue;
            outputStream.writeBytes(System.lineSeparator());
        }
    }

    private void releaseScrollId(String scrollId) {
        if (scrollId == null) {
            return;
        }
        if (PsdkClient.verbose()) {
            PsdkClient.log("Releasing scrollId " + scrollId);
        }
        RequestInteractionListRelease closeCursorRequest = RequestInteractionListRelease.create();
        closeCursorRequest.setScrollId(scrollId);
    }

    String retrieveContact(String contactId) throws ChannelNotClosedException, ProtocolException, InterruptedException, IOException {
        PsdkClient.log("Retrieving contact '" + contactId + "'");
        RequestGetAttributes requestGetAttributes = RequestGetAttributes.create();
        requestGetAttributes.setContactId(contactId);
        Message getAttributesResponse = this.client.request((Message)requestGetAttributes);
        switch (getAttributesResponse.messageId()) {
            case 100: {
                PsdkClient.log("Could not find contact Id '" + contactId + "'");
                this.logUcsError(getAttributesResponse);
                return null;
            }
            case 110: {
                PsdkClient.log("Retrieved contact Id '" + contactId + "'");
                try {
                    return this.serializeToJsonString(getAttributesResponse, null);
                }
                catch (PsdkSerializationException e) {
                    PsdkClient.log("Could not serialize contact Id " + contactId);
                    return null;
                }
            }
        }
        PsdkClient.log("Unexpected message received: " + getAttributesResponse.messageName());
        return null;
    }

    private void writeContactInfo(String fileName, String contactInfo) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);
             DataOutputStream writerStream = new DataOutputStream(new BufferedOutputStream(fos));){
            writerStream.writeBytes(contactInfo);
            writerStream.flush();
        }
    }

    void exportInteractionsForContact(String contactId, Integer tenantId) throws ChannelNotClosedException, ProtocolException, IOException, InterruptedException {
        boolean isContactFound;
        String contactFileName = "contact-".concat(contactId).concat(DOT_JSON);
        String contactFile = Paths.get(InteractionExportManager.getRootPath(), contactFileName).toString();
        String contactAsJson = this.retrieveContact(contactId);
        boolean bl = isContactFound = contactAsJson != null;
        if (isContactFound) {
            PsdkClient.log("Saving contact info to " + contactFile);
            this.writeContactInfo(contactFile, contactAsJson);
            this.exportInteractionsFromDataSource(contactId, tenantId, PsdkClient.SOURCE_MAIN);
            this.exportInteractionsFromDataSource(contactId, tenantId, PsdkClient.SOURCE_ARCHIVE);
        }
    }

    long countInteractionsForContactId(String contactId, Integer tenantId) throws ProtocolException, InterruptedException {
        int totalForMain = this.countInteractionsFromDataSource(contactId, tenantId, PsdkClient.SOURCE_MAIN);
        int totalForArchive = this.countInteractionsFromDataSource(contactId, tenantId, PsdkClient.SOURCE_ARCHIVE);
        return totalForMain + totalForArchive;
    }

    private int countInteractionsFromDataSource(String contactId, Integer tenantId, DataSourceType source) throws InterruptedException, ProtocolException {
        RequestCountInteractions requestCountInteractions = RequestCountInteractions.create();
        SearchCriteriaCollection searchCriteria = this.client.buildInteractionSearchRequest(contactId);
        requestCountInteractions.setSearchCriteria(searchCriteria);
        requestCountInteractions.setDataSource(source);
        requestCountInteractions.setTenantId(tenantId);
        Message countInteractionsResponse = this.client.request((Message)requestCountInteractions);
        switch (countInteractionsResponse.messageId()) {
            case 100: {
                PsdkClient.log("No interactions found for contact Id '" + contactId + "' in source " + source.name());
                this.logUcsError(countInteractionsResponse);
                break;
            }
            case 143: {
                EventCountInteractions eventCountInteractionsResponse = (EventCountInteractions)countInteractionsResponse;
                int totalInteractions = eventCountInteractionsResponse.getTotalCount();
                String interactions = totalInteractions > 1 ? " interactions" : " interaction";
                PsdkClient.log(totalInteractions + interactions + " found for contact Id '" + contactId + "' in source " + source.name());
                return totalInteractions;
            }
        }
        return 0;
    }

    private void logUcsError(Message event) {
        if (event.messageId() != 100) {
            PsdkClient.log("Invalid message provided. Got " + event.messageName() + " but expected EventError message type");
            return;
        }
        EventError errorMessage = (EventError)event;
        PsdkClient.log("Reason: " + errorMessage.getFaultString());
        if (PsdkClient.verbose()) {
            PsdkClient.log(errorMessage.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportInteractionsFromDataSource(String contactId, Integer tenantId, DataSourceType source) throws ChannelNotClosedException, ProtocolException, InterruptedException {
        String interactionsFileName = "interactions-for-contact-".concat(contactId).concat(DOT_JSON);
        String interactionFile = Paths.get(InteractionExportManager.getRootPath(), interactionsFileName).toString();
        PsdkClient.log("Saving interactions to " + interactionFile);
        PsdkClient.log("===============");
        boolean appendToFile = source.equals((Object)PsdkClient.SOURCE_ARCHIVE);
        SearchCriteriaCollection searchCriteria = this.client.buildInteractionSearchRequest(contactId);
        RequestInteractionListGet requestInteractionsList = RequestInteractionListGet.create();
        requestInteractionsList.setDataSource(source);
        requestInteractionsList.setPageMaxSize(MAX_PAGE_SIZE);
        requestInteractionsList.setTenantId(tenantId);
        requestInteractionsList.setSearchCriteria(searchCriteria);
        Message interactionsListResponse = this.client.request((Message)requestInteractionsList);
        switch (interactionsListResponse.messageId()) {
            case 100: {
                PsdkClient.log("No interactions found for contact Id '" + contactId + "' in source " + source.name());
                this.logUcsError(interactionsListResponse);
                break;
            }
            case 139: {
                boolean hasInteractions;
                EventInteractionListGet eventInteractionListGetResponse = (EventInteractionListGet)interactionsListResponse;
                InteractionDataList interactionDataList = eventInteractionListGetResponse.getInteractionData();
                boolean bl = hasInteractions = interactionDataList != null && interactionDataList.size() > 0;
                if (hasInteractions) {
                    PsdkClient.log("Found interactions for contact '" + contactId + "' in source " + source.name());
                } else {
                    PsdkClient.log("0 interaction for contact '" + contactId + "' in source " + source.name());
                }
                String scrollId = this.getScrollId(eventInteractionListGetResponse);
                try (FileOutputStream fos = new FileOutputStream(interactionFile, appendToFile);
                     DataOutputStream writerStream = new DataOutputStream(new BufferedOutputStream(fos));){
                    if (appendToFile) {
                        writerStream.writeBytes(System.lineSeparator());
                    }
                    this.persistInteractions(interactionDataList, source, writerStream);
                    boolean hasMoreInteractions = this.hasNext((Message)eventInteractionListGetResponse);
                    while (hasMoreInteractions) {
                        writerStream.writeBytes(System.lineSeparator());
                        RequestInteractionListGetNextPage requestNexPage = RequestInteractionListGetNextPage.create();
                        requestNexPage.setPageMaxSize(MAX_PAGE_SIZE);
                        requestNexPage.setScrollId(scrollId);
                        Message nextPageResponse = this.client.request((Message)requestNexPage);
                        switch (nextPageResponse.messageId()) {
                            case 100: {
                                hasMoreInteractions = false;
                                PsdkClient.log("Error to get nextPageResponse for '" + contactId + "'");
                                this.logUcsError(nextPageResponse);
                                break;
                            }
                            case 140: {
                                EventInteractionListGetNextPage interactionListGetResponse = (EventInteractionListGetNextPage)nextPageResponse;
                                hasMoreInteractions = this.hasNext(nextPageResponse);
                                interactionDataList = interactionListGetResponse.getInteractionData();
                                this.persistInteractions(interactionDataList, source, writerStream);
                            }
                        }
                    }
                    writerStream.flush();
                    PsdkClient.log("Successfully exported all interactions for contactId '" + contactId + "' from DataSource " + source.name());
                    break;
                }
                catch (PsdkSerializationException | IOException e) {
                    PsdkClient.log("An Exception occurred when exporting interactions for contact '" + contactId + "' from DataSource " + source.name());
                    break;
                }
                finally {
                    this.releaseScrollId(scrollId);
                }
            }
        }
    }

    private static enum ExportMode {
        EXPORT,
        COUNT_ONLY;

    }
}

