/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.eservices.gdpr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.genesyslab.eservices.gdpr.utils.UcsKvlConverter;
import com.genesyslab.platform.commons.protocol.ChannelNotClosedException;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.contacts.protocol.UniversalContactServerProtocol;
import com.genesyslab.platform.contacts.protocol.contactserver.DataSourceType;
import com.genesyslab.platform.contacts.protocol.contactserver.Operators;
import com.genesyslab.platform.contacts.protocol.contactserver.SearchCriteriaCollection;
import com.genesyslab.platform.contacts.protocol.contactserver.SimpleSearchCriteria;
import com.genesyslab.platform.contacts.protocol.contactserver.StringList;
import com.genesyslab.platform.contacts.protocol.contactserver.events.EventCountInteractions;
import com.genesyslab.platform.contacts.protocol.contactserver.events.EventError;
import com.genesyslab.platform.contacts.protocol.contactserver.events.EventIdentifyContact;
import com.genesyslab.platform.contacts.protocol.contactserver.requests.RequestCountInteractions;
import com.genesyslab.platform.contacts.protocol.contactserver.requests.RequestIdentifyContact;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

class PsdkClient {
    static final DataSourceType SOURCE_MAIN = DataSourceType.Main;
    static final DataSourceType SOURCE_ARCHIVE = DataSourceType.Archive;
    static final Integer TENANT_ID = Integer.getInteger("tenantId", 101);
    private static final String VERBOSE = System.getenv("VERBOSE");
    private static final String UCS_HOST = System.getenv("HOST");
    private static final String UCS_PORT = System.getenv("PORT");
    private static final String TIMEOUT = System.getenv("TIMEOUT");
    static Long TIMEOUT_LONG = 60000L;
    private final UniversalContactServerProtocol client;

    static boolean verbose() {
        return Boolean.parseBoolean(VERBOSE);
    }

    static void log(String message) {
        System.out.println(new Date() + ": " + message);
    }

    PsdkClient() {
        Endpoint endPoint = new Endpoint(UCS_HOST, Integer.parseInt(UCS_PORT));
        this.client = new UniversalContactServerProtocol(endPoint);
        if (TIMEOUT != null) {
            TIMEOUT_LONG = Long.parseLong(TIMEOUT);
        }
        this.client.setTimeout(TIMEOUT_LONG.longValue());
    }

    void connect() throws ChannelNotClosedException, ProtocolException, InterruptedException {
        PsdkClient.log("Connecting to UCS at " + UCS_HOST + ":" + UCS_PORT);
        this.client.open(TIMEOUT_LONG.longValue());
    }

    void disconnect() throws ProtocolException, IllegalStateException, InterruptedException {
        this.client.close(TIMEOUT_LONG.longValue());
    }

    Message request(Message request, long timeOut) throws ProtocolException, IllegalStateException, InterruptedException {
        Message message = this.client.request(request, timeOut);
        if (message == null) {
            PsdkClient.log("Timeout for request:" + request);
            this.disconnect();
            System.exit(-1);
        }
        if (PsdkClient.verbose()) {
            PsdkClient.log(message.toString());
        }
        return message;
    }

    Message request(Message request) throws ProtocolException, IllegalStateException, InterruptedException {
        return this.request(request, TIMEOUT_LONG);
    }

    String[] getIds(String id) throws ProtocolException, InterruptedException {
        if (id.startsWith("{")) {
            return this.identifyContact(id);
        }
        return id.split(",");
    }

    static String getUnNamedArgument(String[] args, String value) {
        for (String arg : args) {
            if (arg.equalsIgnoreCase(value)) continue;
            return arg;
        }
        return null;
    }

    SearchCriteriaCollection buildInteractionSearchRequest(String contactId) {
        SearchCriteriaCollection searchCriteria = new SearchCriteriaCollection();
        SimpleSearchCriteria simpleSearch = new SimpleSearchCriteria();
        simpleSearch.setAttrName("ContactId");
        simpleSearch.setAttrValue(contactId);
        simpleSearch.setOperator(Operators.Equal);
        searchCriteria.add((Object)simpleSearch);
        return searchCriteria;
    }

    static Integer getTenantId(String json, Integer defaultTenantId) throws IOException {
        JsonNode jsonObject;
        JsonNode tenantNode;
        ObjectMapper objectMapper = new ObjectMapper();
        if (json == null) {
            return defaultTenantId;
        }
        if (!json.startsWith("{")) {
            return defaultTenantId;
        }
        if (PsdkClient.verbose()) {
            PsdkClient.log("Json raw input: '" + json + "'");
        }
        String parsedJson = json.replaceAll("''", "\"");
        if (PsdkClient.verbose()) {
            PsdkClient.log("Json for search: '" + parsedJson + "'");
        }
        if ((tenantNode = (jsonObject = objectMapper.readTree(parsedJson)).findValue("TenantId")) != null) {
            return tenantNode.asInt(defaultTenantId.intValue());
        }
        return defaultTenantId;
    }

    long countInteractionsForContactId(String contactId, Integer tenantId) throws ProtocolException {
        int totalForMain = this.countInteractionsFromDataSource(contactId, tenantId, SOURCE_MAIN);
        int totalForArchive = this.countInteractionsFromDataSource(contactId, tenantId, SOURCE_ARCHIVE);
        return totalForMain + totalForArchive;
    }

    private int countInteractionsFromDataSource(String contactId, Integer tenantId, DataSourceType source) throws ProtocolException {
        RequestCountInteractions requestCountInteractions = RequestCountInteractions.create();
        SearchCriteriaCollection searchCriteria = this.buildInteractionSearchRequest(contactId);
        requestCountInteractions.setSearchCriteria(searchCriteria);
        requestCountInteractions.setDataSource(source);
        requestCountInteractions.setTenantId(tenantId);
        Message countInteractionsResponse = this.client.request((Message)requestCountInteractions);
        switch (countInteractionsResponse.messageId()) {
            case 100: {
                PsdkClient.log("No interactions found for contact Id '" + contactId + "' in source " + source.name());
                EventError errorMessage = (EventError)countInteractionsResponse;
                PsdkClient.log("Reason: " + errorMessage.getFaultString());
                if (!PsdkClient.verbose()) break;
                PsdkClient.log(errorMessage.toString());
                break;
            }
            case 143: {
                EventCountInteractions eventCountInteractionsResponse = (EventCountInteractions)countInteractionsResponse;
                int totalInteractions = eventCountInteractionsResponse.getTotalCount();
                String interactions = totalInteractions > 1 ? " interactions" : " interaction";
                PsdkClient.log(totalInteractions + interactions + " found for contact Id '" + contactId + "' in source " + source.name());
                return totalInteractions;
            }
        }
        return 0;
    }

    private String[] identifyContact(String json) throws InterruptedException, ProtocolException {
        if (json == null) {
            return new String[0];
        }
        json = json.replaceAll("''", "\"");
        PsdkClient.log("Identify Contact with '" + json + "'");
        RequestIdentifyContact requestIdentifyContact = RequestIdentifyContact.create();
        requestIdentifyContact.setCreateContact(Boolean.valueOf(false));
        requestIdentifyContact.setReturnUnique(Boolean.valueOf(false));
        requestIdentifyContact.setOtherFields(UcsKvlConverter.jsonToKeyValueCollection(json));
        Message message = this.request((Message)requestIdentifyContact);
        if (message instanceof EventIdentifyContact) {
            String contactId;
            String cId = ((EventIdentifyContact)message).getContactId();
            int numberOfContactsFound = ((EventIdentifyContact)message).getNumberOfContactsFound();
            StringList allMatchingContacts = ((EventIdentifyContact)message).getContactIdList();
            if (cId == null && allMatchingContacts != null && !allMatchingContacts.isEmpty()) {
                cId = (String)allMatchingContacts.get(0);
            }
            if ((contactId = cId) != null) {
                PsdkClient.log("Contact identified: '" + contactId + "'");
                if (numberOfContactsFound > 1) {
                    ArrayList<String> otherContactIds = new ArrayList<String>();
                    for (String otherContact : allMatchingContacts) {
                        if (otherContact.equals(contactId)) continue;
                        otherContactIds.add(otherContact);
                    }
                    PsdkClient.log("Other matching contacts: " + otherContactIds);
                }
                return new String[]{contactId};
            }
            if (numberOfContactsFound == 0) {
                PsdkClient.log("No contact matches these identification parameters");
                return new String[0];
            }
        }
        PsdkClient.log(message.toString());
        return new String[0];
    }
}

