/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.eservices.gdpr.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.UTFValue;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class UcsKvlConverter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final String BINARY = "binary";
    private static final String NULL_VALUE = "null_value";

    public static String keyValueCollectionToJson(KeyValueCollection keyValueCollection) {
        try {
            StringWriter stringWriter = new StringWriter();
            JsonGenerator builder = JSON_FACTORY.createGenerator((Writer)stringWriter);
            builder.writeStartObject();
            UcsKvlConverter.serializeKeyValueCollection(keyValueCollection, builder);
            builder.writeEndObject();
            builder.close();
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize attributes to Json", e);
        }
    }

    public static KeyValueCollection jsonToKeyValueCollection(String jsonString) {
        block5: {
            try {
                if (jsonString != null && !"".equals(jsonString.trim())) {
                    JsonNode jsonRoot = OBJECT_MAPPER.readTree(jsonString);
                    if (jsonRoot.isArray()) {
                        return UcsKvlConverter.jsonArrayToKeyValueCollection(jsonRoot);
                    }
                    if (jsonRoot.isObject()) {
                        return UcsKvlConverter.jsonObjectToKeyValueCollection(jsonRoot);
                    }
                    break block5;
                }
                return new KeyValueCollection();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to deserialize Json to ParameterMap");
            }
        }
        throw new RuntimeException("Failed to deserialize Json to ParameterMap, json is neither an array nor an object");
    }

    private static void serializeKeyValueCollection(KeyValueCollection keyValueCollection, JsonGenerator jsonGenerator) {
        for (Object aKeyValueCollection : keyValueCollection) {
            KeyValuePair keyValuePair = (KeyValuePair)aKeyValueCollection;
            UcsKvlConverter.addEntry(jsonGenerator, keyValuePair.getStringKey(), keyValuePair.getValue());
        }
    }

    private static void addEntry(JsonGenerator jsonGenerator, String name, Object value) {
        try {
            if (value == null) {
                jsonGenerator.writeStringField(name, NULL_VALUE);
            } else if (value instanceof byte[]) {
                UcsKvlConverter.serializeBinary(jsonGenerator, name, (byte[])value);
            } else if (value instanceof KeyValueCollection) {
                KeyValueCollection keyValueCollection = (KeyValueCollection)value;
                if (name != null) {
                    jsonGenerator.writeFieldName(name);
                }
                jsonGenerator.writeStartObject();
                UcsKvlConverter.serializeKeyValueCollection(keyValueCollection, jsonGenerator);
                jsonGenerator.writeEndObject();
            } else if (value instanceof UTFValue) {
                jsonGenerator.writeStringField(name, ((UTFValue)value).getValue());
            } else if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (name != null) {
                    jsonGenerator.writeFieldName(name);
                }
                jsonGenerator.writeStartArray();
                for (Object collectionValue : collection) {
                    if (collectionValue instanceof byte[]) {
                        UcsKvlConverter.serializeBinary(jsonGenerator, null, (byte[])collectionValue);
                        continue;
                    }
                    if (collectionValue instanceof Collection) {
                        UcsKvlConverter.addEntry(jsonGenerator, null, collectionValue);
                        continue;
                    }
                    jsonGenerator.writeObject(collectionValue);
                }
                jsonGenerator.writeEndArray();
            } else {
                jsonGenerator.writeObjectField(name, value);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static KeyValueCollection jsonObjectToKeyValueCollection(JsonNode objectNode) {
        KeyValueCollection keyValueCollection = new KeyValueCollection();
        Iterator it = objectNode.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            UcsKvlConverter.addToKeyValueCollection(keyValueCollection, (String)entry.getKey(), (JsonNode)entry.getValue());
        }
        return keyValueCollection;
    }

    private static void addToKeyValueCollection(KeyValueCollection keyValueCollection, String key, JsonNode jsonNode) {
        if (jsonNode.isNull()) {
            keyValueCollection.addString(key, null);
        } else if (jsonNode.isInt()) {
            keyValueCollection.addInt(key, jsonNode.asInt());
        } else if (jsonNode.isNumber()) {
            keyValueCollection.addInt(key, jsonNode.asInt());
        } else if (jsonNode.isBoolean()) {
            keyValueCollection.addString(key, jsonNode.asText());
        } else if (jsonNode.isTextual()) {
            String text = jsonNode.asText();
            if (NULL_VALUE.equals(text)) {
                keyValueCollection.addString(key, null);
            } else {
                keyValueCollection.addString(key, text);
            }
        } else if (jsonNode.isArray()) {
            keyValueCollection.addList(key, UcsKvlConverter.jsonArrayToKeyValueCollection(jsonNode));
        } else if (UcsKvlConverter.isBinary(jsonNode)) {
            try {
                keyValueCollection.addBinary(key, UcsKvlConverter.toByteArray(jsonNode));
            }
            catch (IllegalArgumentException iae) {
                keyValueCollection.addList(key, UcsKvlConverter.jsonObjectToKeyValueCollection(jsonNode));
            }
        } else if (jsonNode.isObject()) {
            keyValueCollection.addList(key, UcsKvlConverter.jsonObjectToKeyValueCollection(jsonNode));
        } else {
            throw new RuntimeException("Failed to deserialize Json to ParameterMap, json type unknown");
        }
    }

    private static KeyValueCollection jsonArrayToKeyValueCollection(JsonNode arrayNode) {
        int pos = 0;
        KeyValueCollection keyValueCollection = new KeyValueCollection();
        Iterator it = arrayNode.elements();
        while (it.hasNext()) {
            UcsKvlConverter.addToKeyValueCollection(keyValueCollection, String.valueOf(pos), (JsonNode)it.next());
            ++pos;
        }
        return keyValueCollection;
    }

    private static boolean isBinary(JsonNode objectNode) {
        if (objectNode.size() == 1) {
            JsonNode binaryNode = objectNode.get(BINARY);
            return binaryNode != null && binaryNode.asText() != null;
        }
        return false;
    }

    private static byte[] toByteArray(JsonNode objectNode) {
        String binaryValue;
        JsonNode binaryNode;
        if (objectNode.size() == 1 && (binaryNode = objectNode.get(BINARY)) != null && (binaryValue = binaryNode.asText()) != null) {
            return BaseEncoding.base64().decode((CharSequence)binaryValue);
        }
        return null;
    }

    private static void serializeBinary(JsonGenerator jsonGenerator, String name, byte[] value) throws IOException {
        if (name != null) {
            jsonGenerator.writeFieldName(name);
        }
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(BINARY, BaseEncoding.base64().encode(value));
        jsonGenerator.writeEndObject();
    }
}

