/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections;

import com.genesyslab.platform.commons.collections.DataFormatException;
import com.genesyslab.platform.commons.collections.KVList;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.Pair;
import com.genesyslab.platform.commons.collections.TKVSerializer;
import com.genesyslab.platform.commons.collections.processor.KeyValuePrinter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class KeyValueCollection
extends KVList {
    private static final long serialVersionUID = -967251974937411040L;

    public KeyValueCollection() {
    }

    protected KeyValueCollection(KeyValueCollection list) {
        this.storage = list.storage;
    }

    public void addPair(KeyValuePair pair) {
        if (pair == null) {
            throw new NullPointerException("pair can't be null");
        }
        this.storage.add(pair);
    }

    public KeyValuePair getPair(String key) {
        return (KeyValuePair)this.storage.findPair(key);
    }

    public KeyValuePair remove(String key) {
        return (KeyValuePair)this.removePair(key);
    }

    public void addList(String key, KeyValueCollection list) {
        KeyValuePair pair = (KeyValuePair)this.createPair(key);
        pair.setTKVValue(list);
        this.storage.add(pair);
    }

    public KeyValueCollection getList(String key) {
        KeyValuePair pair = (KeyValuePair)this.storage.findPair(key);
        if (pair == null) {
            return null;
        }
        return pair.getTKVValue();
    }

    @Override
    public void addObject(String key, Object value) throws IllegalArgumentException {
        if (value instanceof KeyValueCollection) {
            KeyValuePair pair = (KeyValuePair)this.createPair(key);
            pair.setTKVValue((KeyValueCollection)value);
            this.storage.add(pair);
        } else {
            super.addObject(key, value);
        }
    }

    @Override
    public String toString() {
        KeyValuePrinter printer = KeyValuePrinter.getDefaultPrinter();
        return printer.toString(this);
    }

    public String toStringLine() {
        return this.storage.toString();
    }

    @Override
    protected Pair createPair(Object key) {
        if (key == null) {
            throw new NullPointerException("TKVList can't accept null key");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("TKVList accepts only String as a key. Found: " + key.getClass().getName());
        }
        return new KeyValuePair((String)key);
    }

    @Override
    protected void throwNotPair(Object o) {
        if (!(o instanceof KeyValuePair)) {
            throw new IllegalArgumentException("Only TKVPairs are supported in TKVList");
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        TKVSerializer.serialize(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            KeyValueCollection lst = TKVSerializer.deserialize(stream);
            this.storage = lst.storage;
        }
        catch (DataFormatException e) {
            throw new IOException("Corrupted data: " + e.getMessage());
        }
    }
}

