/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections;

import com.genesyslab.platform.commons.collections.DataFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

class SerialUtil {
    public static final String UTF_ENCODING = "UTF-16BE";

    SerialUtil() {
    }

    public static byte[] getBytes(String s, String encoding) throws UnsupportedEncodingException {
        if (s == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (encoding == null) {
            return s.getBytes();
        }
        return s.getBytes(encoding);
    }

    public static byte read(InputStream in) throws IOException, DataFormatException {
        int bt = in.read();
        if (bt == -1) {
            throw new DataFormatException("unexpected end of stream");
        }
        return (byte)bt;
    }

    public static byte[] readBytes(InputStream in, int len) throws IOException, DataFormatException {
        byte[] bytes = new byte[len];
        if (len > 0) {
            int i;
            for (int bytesRead = i = in.read(bytes); i != 0 && bytesRead < len; bytesRead += i) {
                if (i == -1) {
                    throw new DataFormatException("unexpected end of stream");
                }
                i = in.read(bytes, bytesRead, len - bytesRead);
            }
        }
        return bytes;
    }
}

