/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections;

import com.genesyslab.platform.commons.collections.DataFormatException;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.ValueType;
import com.genesyslab.platform.commons.collections.util.Base64;
import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TKVXmlSerializer {
    private static final String TKV_ELEMENT_NAME = "TKVList";
    private static final String PAIR_ELEMENT_NAME = "Pair";
    private static final String KEY_ATTR_NAME = "key";
    private static final String TYPE_ATTR_NAME = "type";
    private static final String NS_ATTR_NAME = "xmlns";
    private static final String COMMONS_NS_NAME = "http://schemas.genesyslab.com/Commons/2005/";

    public static Document serialize(KeyValueCollection list) throws ParserConfigurationException {
        Document doc = XmlFactories.newDocumentBuilder().newDocument();
        Element root = TKVXmlSerializer.serialize(list, doc);
        doc.appendChild(root);
        return doc;
    }

    public static Element serialize(KeyValueCollection list, Document nodeFactory) {
        Element listElement = nodeFactory.createElementNS(COMMONS_NS_NAME, TKV_ELEMENT_NAME);
        listElement.setAttribute(NS_ATTR_NAME, COMMONS_NS_NAME);
        Enumeration pairs = list.getEnumeration();
        while (pairs.hasMoreElements()) {
            KeyValuePair pair = (KeyValuePair)pairs.nextElement();
            TKVXmlSerializer.appendPair(listElement, pair);
        }
        return listElement;
    }

    public static KeyValueCollection deserialize(Document listDocument) throws DataFormatException {
        Element listElement = listDocument.getDocumentElement();
        return TKVXmlSerializer.deserialize(listElement);
    }

    public static KeyValueCollection deserialize(Element listElement) throws DataFormatException {
        if (!listElement.getNodeName().equals(TKV_ELEMENT_NAME)) {
            throw new DataFormatException("Wrong top level element");
        }
        KeyValueCollection list = new KeyValueCollection();
        Element pairElem = TKVXmlSerializer.getFirstChild(listElement);
        while (pairElem != null) {
            TKVXmlSerializer.restorePair(list, pairElem);
            pairElem = TKVXmlSerializer.getNextSibling(pairElem);
        }
        return list;
    }

    private static void restorePair(KeyValueCollection list, Element pairElem) throws DataFormatException {
        if (!pairElem.getNodeName().equals(PAIR_ELEMENT_NAME)) {
            throw new DataFormatException("Pair element expected");
        }
        String key = pairElem.getAttribute(KEY_ATTR_NAME);
        if (key == null) {
            throw new DataFormatException("'key' attribute expected in Pair element ");
        }
        String type = pairElem.getAttribute(TYPE_ATTR_NAME);
        if (type == null) {
            throw new DataFormatException("'type' attribute expected in Pair element ");
        }
        KeyValuePair pair = TKVXmlSerializer.getListPair(pairElem, key, type);
        list.addPair(pair);
    }

    private static KeyValuePair getListPair(Element pairElem, String key, String type) throws DataFormatException {
        KeyValuePair pair = new KeyValuePair(key);
        if (type.equals("string")) {
            String val = TKVXmlSerializer.getElementText(pairElem);
            pair.setStringValue(val);
        } else if (type.equals("int")) {
            int val = Integer.parseInt(TKVXmlSerializer.getElementText(pairElem));
            pair.setIntValue(val);
        } else if (type.equals("utf")) {
            String val = TKVXmlSerializer.getElementText(pairElem);
            pair.setUTF16Value(val);
        } else if (type.equals("binary")) {
            String binData = TKVXmlSerializer.getElementText(pairElem);
            byte[] val = Base64.decodeBase64(binData.getBytes());
            pair.setBinaryValue(val);
        } else if (type.equals("tkv")) {
            Element listElem = TKVXmlSerializer.getFirstChild(pairElem);
            if (listElem != null) {
                KeyValueCollection val = TKVXmlSerializer.deserialize(listElem);
                pair.setTKVValue(val);
            }
        } else {
            throw new DataFormatException("Unsupported type: " + type);
        }
        return pair;
    }

    private static String getElementText(Element elem) {
        StringBuffer buf = new StringBuffer();
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            buf.append(node.getNodeValue());
        }
        return buf.toString();
    }

    private static Element getFirstChild(Element parent) {
        Node node;
        for (node = parent.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    private static Element getNextSibling(Element elem) {
        Node node;
        for (node = elem.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    private static void appendPair(Element listElement, KeyValuePair pair) {
        Element pairElement = listElement.getOwnerDocument().createElementNS(COMMONS_NS_NAME, PAIR_ELEMENT_NAME);
        pairElement.setAttribute(KEY_ATTR_NAME, pair.getStringKey());
        pairElement.setAttribute(TYPE_ATTR_NAME, TKVXmlSerializer.getTypeSignature(pair));
        TKVXmlSerializer.appendPairContent(pairElement, pair);
        listElement.appendChild(pairElement);
    }

    private static void appendPairContent(Element pairElement, KeyValuePair pair) {
        if (pair == null) {
            return;
        }
        ValueType valueType = pair.getValueType();
        if (ValueType.STRING.equals(valueType)) {
            TKVXmlSerializer.appendText(pairElement, pair.getStringValue());
        } else if (ValueType.INT.equals(valueType)) {
            TKVXmlSerializer.appendText(pairElement, String.valueOf(pair.getIntValue()));
        } else if (ValueType.BINARY.equals(valueType)) {
            byte[] bytes = pair.getBinaryValue();
            String binData = new String(Base64.encodeBase64Chunked(bytes));
            TKVXmlSerializer.appendText(pairElement, "\n" + binData);
        } else if (ValueType.WIDE_STRING.equals(valueType)) {
            TKVXmlSerializer.appendText(pairElement, pair.getStringValue());
        } else if (ValueType.TKV_LIST.equals(valueType)) {
            Element listElement = TKVXmlSerializer.serialize(pair.getTKVValue(), pairElement.getOwnerDocument());
            pairElement.appendChild(listElement);
        }
    }

    private static void appendText(Element pairElement, String stringValue) {
        Document nodeFactory = pairElement.getOwnerDocument();
        pairElement.appendChild(nodeFactory.createTextNode(stringValue));
    }

    private static String getTypeSignature(KeyValuePair pair) {
        ValueType valueType = pair.getValueType();
        if (ValueType.STRING.equals(valueType)) {
            return "string";
        }
        if (ValueType.INT.equals(valueType)) {
            return "int";
        }
        if (ValueType.BINARY.equals(valueType)) {
            return "binary";
        }
        if (ValueType.WIDE_STRING.equals(valueType)) {
            return "utf";
        }
        if (ValueType.TKV_LIST.equals(valueType)) {
            return "tkv";
        }
        return null;
    }
}

