/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections.runtime.processor;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.processor.KeyValuePrinterContext;
import com.genesyslab.platform.commons.collections.runtime.processor.CopyOutputFilter;

public abstract class HideCharsFilter
extends CopyOutputFilter {
    private int charCount = -1;

    public HideCharsFilter(int nCharCount) {
        this.charCount = nCharCount;
    }

    @Override
    public void configure(KeyValueCollection options) {
        int iCharCount;
        super.configure(options);
        if (options == null) {
            return;
        }
        Integer integerValue = options.getInt("hide-first-count");
        if (null != integerValue) {
            iCharCount = integerValue;
        } else {
            integerValue = options.getInt("hide-last-count");
            if (null != integerValue) {
                iCharCount = integerValue;
            } else {
                integerValue = options.getInt("unhide-first-count");
                if (null != integerValue) {
                    iCharCount = integerValue;
                } else {
                    integerValue = options.getInt("unhide-last-count");
                    if (null != integerValue) {
                        iCharCount = integerValue;
                    } else {
                        throw new IllegalArgumentException("No known characters number parameter specified for " + this.getClass().getSimpleName());
                    }
                }
            }
        }
        if (iCharCount <= 0) {
            throw new IllegalArgumentException("Characters number for " + this.getClass().getSimpleName() + " filter parameter should be positive value");
        }
        this.charCount = iCharCount;
    }

    protected abstract String hideValue(String var1, int var2);

    protected int getCharCount(KeyValuePrinterContext context) {
        return this.charCount;
    }

    @Override
    protected String doAppendPairValue(StringBuffer buf, String key, Object value, KeyValuePrinterContext context) {
        if (value instanceof String) {
            buf.append('\"').append(this.hideValue((String)value, this.getCharCount(context))).append('\"');
        } else if (value instanceof Integer) {
            buf.append('\"').append(this.hideValue(value.toString(), this.getCharCount(context))).append('\"');
        } else {
            return super.doAppendPairValue(buf, key, value, context);
        }
        return null;
    }

    protected String getMaskString(int len) {
        if (len > 0) {
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = 42;
            }
            return new String(chars);
        }
        return "";
    }
}

