/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections.util;

public class Hex {
    private static final char[] DIGITS_LO = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int TRUNCATE_BYTES_LEN = 150;

    public static byte[] decodeHex(char[] data) throws NumberFormatException {
        int len = data.length;
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Hex.toDigit(data[j], j) << 4;
            f |= Hex.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) throws NumberFormatException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new NumberFormatException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static char[] encodeHex(byte[] data) {
        return Hex.encodeHex(data, 0, data.length);
    }

    public static char[] encodeHex(byte[] data, int offset, int len) {
        return Hex.encodeHex(data, offset, len, false);
    }

    public static char[] encodeHEX(byte[] data) {
        return Hex.encodeHEX(data, 0, data.length);
    }

    public static char[] encodeHEX(byte[] data, int offset, int len) {
        return Hex.encodeHex(data, offset, len, true);
    }

    public static char[] encodeHex(byte[] data, int offset, int len, boolean upperCase) {
        char[] DIGITS = upperCase ? DIGITS_UP : DIGITS_LO;
        int l = len;
        if (l > data.length - offset) {
            l = data.length - offset;
        }
        char[] out = new char[l << 1];
        int endIndex = l + offset;
        int j = 0;
        for (int i = offset; i < endIndex; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }

    public static void appendBytesStr(StringBuffer buf, byte[] bytes) {
        Hex.appendBytesStr(buf, bytes, false);
    }

    public static void appendBytesStr(StringBuffer buf, byte[] bytes, boolean truncate) {
        Hex.appendBytesStr(buf, bytes, truncate, 150);
    }

    public static void appendBytesStr(StringBuffer buf, byte[] bytes, boolean truncate, int truncateThreshold) {
        char[] hex = truncate && bytes.length > truncateThreshold ? Hex.encodeHex(bytes, 0, truncateThreshold) : Hex.encodeHex(bytes);
        int len = hex.length;
        for (int i = 0; i < len; i += 2) {
            if (i % 20 == 0) {
                buf.append("\n\t  ");
            }
            buf.append(' ').append('0').append('x').append(hex[i]).append(hex[i + 1]);
        }
        if (truncate && bytes.length > truncateThreshold) {
            int remaining = bytes.length - truncateThreshold;
            buf.append("\n\t   ... [output truncated, ").append(remaining).append(" bytes left out of ").append(bytes.length).append("]");
        }
    }

    public static void appendBytesStr(StringBuilder buf, byte[] bytes, boolean truncate) {
        Hex.appendBytesStr(buf, bytes, truncate, 150);
    }

    public static void appendBytesStr(StringBuilder buf, byte[] bytes, boolean truncate, int truncateThreshold) {
        char[] hex = truncate && bytes.length > truncateThreshold ? Hex.encodeHex(bytes, 0, truncateThreshold) : Hex.encodeHex(bytes);
        int len = hex.length;
        for (int i = 0; i < len; i += 2) {
            if (i % 20 == 0) {
                buf.append("\n\t  ");
            }
            buf.append(' ').append('0').append('x').append(hex[i]).append(hex[i + 1]);
        }
        if (truncate && bytes.length > truncateThreshold) {
            int remaining = bytes.length - truncateThreshold;
            buf.append("\n\t   ... [output truncated, ").append(remaining).append(" bytes left out of ").append(bytes.length).append("]");
        }
    }

    public static StringBuilder appendHexAndAscTable(StringBuilder sb, byte[] data, String indent) {
        return Hex.appendHexAndAscTable(sb, data, 0, data.length, indent);
    }

    public static StringBuilder appendHexAndAscTable(StringBuilder sb, byte[] data, int offset, int length, String indent) {
        if (sb == null) {
            sb = new StringBuilder(length * 4 + (length + 1) / 16 * 7);
        }
        char[] DIGITS = DIGITS_UP;
        int l = length;
        if (l > data.length - offset) {
            l = data.length - offset;
        }
        int endIndex = l + offset;
        if (length > 0) {
            sb.append(indent);
            int col = -1;
            for (int i = offset; i < endIndex; ++i) {
                boolean lastByte;
                ++col;
                if (((col &= 0xF) & 3) == 0) {
                    sb.append(' ');
                }
                sb.append(DIGITS[(0xF0 & data[i]) >>> 4]);
                sb.append(DIGITS[0xF & data[i]]);
                boolean bl = lastByte = i >= endIndex - 1;
                if (col == 15 || lastByte) {
                    for (int k = col + 1; k < 16; ++k) {
                        if ((k & 3) == 0) {
                            sb.append(' ');
                        }
                        sb.append(' ');
                        sb.append(' ');
                        sb.append(' ');
                    }
                    sb.append(' ');
                    sb.append('|');
                    for (int j = i - col; j <= i; ++j) {
                        byte cJ = data[j];
                        if (cJ == 13 || cJ == 10 || cJ == 0) {
                            sb.append(' ');
                            continue;
                        }
                        sb.append((char)cJ);
                    }
                    sb.append('|');
                    if (lastByte) break;
                }
                if (lastByte) continue;
                if (col == 15) {
                    sb.append('\n');
                    sb.append(indent);
                    continue;
                }
                sb.append(' ');
            }
        }
        return sb;
    }
}

