/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.genesyslab.platform.reporting.protocol.statserver.BaseCollection;
import com.genesyslab.platform.reporting.protocol.statserver.InternalUtils;
import java.io.IOException;

abstract class BaseCollectionDeserializer<E, T extends BaseCollection<E>>
extends JsonDeserializer<T> {
    BaseCollectionDeserializer() {
    }

    public abstract T create();

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken token = JsonToken.START_ARRAY.equals((Object)jp.getCurrentToken()) ? jp.nextToken() : jp.getCurrentToken();
        T collection = this.create();
        Class elementClass = collection.getElementClass();
        while (JsonToken.START_OBJECT.equals((Object)token)) {
            Object item = jp.readValueAs(elementClass);
            InternalUtils.addItem(collection, (Object)item);
            token = jp.nextToken();
        }
        return collection;
    }
}

