/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.genesyslab.platform.json.jackson2.PSDKJSONConstants;
import com.genesyslab.platform.webmedia.protocol.basicchat.BasicChatEventList;
import com.genesyslab.platform.webmedia.protocol.basicchat.runtime.codec.BasicChatEventListCodec;
import java.io.IOException;

class BasicChatEventListDeserializer
extends JsonDeserializer<BasicChatEventList> {
    BasicChatEventListDeserializer() {
    }

    public BasicChatEventList deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        BasicChatEventList result = new BasicChatEventList();
        JsonToken token = JsonToken.START_ARRAY.equals((Object)jp.getCurrentToken()) ? jp.nextToken() : jp.getCurrentToken();
        String JsonKey_Value = PSDKJSONConstants.getJSONKeyForValue(ctxt.getConfig().getPropertyNamingStrategy());
        while (JsonToken.START_OBJECT.equals((Object)token)) {
            Class itemClass;
            token = jp.nextToken();
            if (!JsonToken.FIELD_NAME.equals((Object)token)) {
                throw new JsonParseException("Token 'filed name' for the field $class' is expected. But instead : " + token, jp.getCurrentLocation());
            }
            String itemClassKeyName = jp.getText();
            if (!"$class".equals(itemClassKeyName)) {
                throw new JsonParseException("Field $class' is expected. But instead : " + itemClassKeyName, jp.getCurrentLocation());
            }
            token = jp.nextToken();
            if (!JsonToken.VALUE_STRING.equals((Object)token)) {
                throw new JsonParseException("Token 'value string' for the field $class' is expected. But instead : " + token, jp.getCurrentLocation());
            }
            String eventType = jp.getText();
            if (eventType.startsWith(".")) {
                eventType = eventType.substring(1);
            }
            if ((itemClass = BasicChatEventListCodec.getTypeClass((String)eventType)) == null) {
                throw new JsonParseException("Unknown basic chat event type : " + eventType, jp.getCurrentLocation());
            }
            token = jp.nextToken();
            if (!JsonToken.FIELD_NAME.equals((Object)token)) {
                throw new JsonParseException("Field '" + JsonKey_Value + "' is expected. But instead : " + token, jp.getCurrentLocation());
            }
            String itemDataKeyName = jp.getText();
            if (!JsonKey_Value.equals(itemDataKeyName) && !"data".equals(itemDataKeyName)) {
                throw new JsonParseException("Field '" + JsonKey_Value + "' is expected. But instead : " + itemDataKeyName, jp.getCurrentLocation());
            }
            token = jp.nextToken();
            Object item = jp.readValueAs(itemClass);
            if (item != null) {
                result.add(item);
            }
            token = jp.nextToken();
            token = jp.nextToken();
        }
        return result;
    }
}

