/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectBase;
import com.genesyslab.platform.configuration.protocol.utilities.CfgUtilities;
import com.genesyslab.platform.json.jackson2.MetaDataSupport;
import java.io.IOException;

class ConfObjectBaseSerializer
extends JsonSerializer<ConfObjectBase> {
    private MetaDataSupport metadataSupport;

    public ConfObjectBaseSerializer(MetaDataSupport metadataSupport) {
        this.metadataSupport = metadataSupport;
    }

    public void serialize(ConfObjectBase value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        CfgDescriptionClass classInfo = value.getClassInfo();
        jgen.writeStringField("$class", classInfo.getName());
        PropertyNamingStrategy pns = provider.getConfig().getPropertyNamingStrategy();
        PropertyNamingStrategy.PropertyNamingStrategyBase pnsb = pns instanceof PropertyNamingStrategy.PropertyNamingStrategyBase ? (PropertyNamingStrategy.PropertyNamingStrategyBase)pns : null;
        for (CfgDescriptionAttribute a : classInfo.getAttributes()) {
            Object v = value.getPropertyValue(a.getIndex());
            if (v == null) continue;
            String attrName = a.getSchemaName();
            if (pnsb != null) {
                attrName = pnsb.translate(attrName);
            }
            if (a.isCfgType(CfgTypeMask.Time)) {
                jgen.writeObjectField(attrName, (Object)CfgUtilities.getDateTime((int)((Integer)v)));
                continue;
            }
            jgen.writeObjectField(attrName, v);
        }
        jgen.writeEndObject();
    }
}

