/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.genesyslab.platform.configuration.protocol.obj.ConfObject;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectsCollection;
import com.genesyslab.platform.json.jackson2.MetaDataSupport;
import java.io.IOException;

class ConfObjectsCollectionDeserializer
extends JsonDeserializer<ConfObjectsCollection> {
    private MetaDataSupport metadataSupport;

    public ConfObjectsCollectionDeserializer(MetaDataSupport metadataSupport) {
        this.metadataSupport = metadataSupport;
    }

    public ConfObjectsCollection deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (!JsonToken.START_ARRAY.equals((Object)jp.getCurrentToken())) {
            throw new JsonParseException("Array start is expected", jp.getCurrentLocation());
        }
        jp.nextToken();
        ConfObjectsCollection col = null;
        while (!JsonToken.END_ARRAY.equals((Object)jp.getCurrentToken())) {
            if (!JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                throw new JsonParseException("Structure value is expected", jp.getCurrentLocation());
            }
            ConfObject item = (ConfObject)jp.getCodec().readValue(jp, ConfObject.class);
            if (item == null) continue;
            if (col == null) {
                col = new ConfObjectsCollection(item.getClassInfo());
            }
            col.add((Object)item);
            jp.nextToken();
        }
        return col;
    }
}

