/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import java.io.IOException;

class KeyValueCollectionDeserializer
extends JsonDeserializer<KeyValueCollection> {
    KeyValueCollectionDeserializer() {
    }

    public KeyValueCollection deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (!JsonToken.START_ARRAY.equals((Object)jp.getCurrentToken())) {
            throw new JsonParseException("Expected start array for key value collection", jp.getTokenLocation());
        }
        ObjectMapper m = (ObjectMapper)jp.getCodec();
        KeyValueCollection kv = new KeyValueCollection();
        while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
            if (!JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                throw new JsonParseException("Expected start object for key value pair", jp.getTokenLocation());
            }
            kv.add(jp.readValueAs(KeyValuePair.class));
        }
        return kv;
    }
}

