/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.genesyslab.platform.json.jackson2.BasicChatModuleConfigurator;
import com.genesyslab.platform.json.jackson2.CallbackModuleConfigurator;
import com.genesyslab.platform.json.jackson2.ConfServerModuleConfigurator;
import com.genesyslab.platform.json.jackson2.ContactServerModuleConfigurator;
import com.genesyslab.platform.json.jackson2.EmailModuleConfigurator;
import com.genesyslab.platform.json.jackson2.FlexChatModuleConfigurator;
import com.genesyslab.platform.json.jackson2.ManagementModuleConfigurator;
import com.genesyslab.platform.json.jackson2.PSDKModuleConfigurator;
import com.genesyslab.platform.json.jackson2.SolutionControlServerModuleConfigurator;
import com.genesyslab.platform.json.jackson2.StatServerModuleConfigurator;
import com.genesyslab.platform.json.jackson2.TServerModuleConfigurator;
import com.genesyslab.platform.json.jackson2.WebMediaModuleConfigurator;
import java.util.HashMap;

class PSDKModulesCustomization {
    private static HashMap<String, PSDKModuleConfigurator> registryProtocolConfigurators = new HashMap();
    private static HashMap<String, PSDKModuleConfigurator> registryCategoryConfigurators = new HashMap();
    private static HashMap<String, String> registryProtocolCheckingClassName = new HashMap();
    private static HashMap<String, String> registryCategoryCheckingClassName = new HashMap();
    static final PSDKModuleConfigurator customConfigurators;

    PSDKModulesCustomization() {
    }

    private static void registerProtocolConfigurator(String protocol, PSDKModuleConfigurator cfg) {
        registryProtocolConfigurators.put(protocol, cfg);
    }

    private static void registerCategoryConfigurator(String category, PSDKModuleConfigurator cfg) {
        registryCategoryConfigurators.put(category, cfg);
    }

    static PSDKModuleConfigurator getProtocolConfigurator(String protocol) {
        return registryProtocolConfigurators.get(protocol);
    }

    static PSDKModuleConfigurator getCategoryConfigurator(String category) {
        return registryCategoryConfigurators.get(category);
    }

    private static void registerProtocolCheckingClassName(String category, String protocol, String customClassName) {
        registryCategoryCheckingClassName.put(category, customClassName);
        registryProtocolCheckingClassName.put(protocol, customClassName);
    }

    static boolean isProtocolAvailable(String category, String protocol) {
        try {
            String className = registryProtocolCheckingClassName.get(protocol);
            if (className == null) {
                className = "com.genesyslab.platform." + category.toLowerCase() + ".protocol." + protocol + "Protocol";
            }
            return Class.forName(className) != null;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static void init() {
        PSDKModulesCustomization.registerProtocolCheckingClassName("Contacts", "ContactServer", "com.genesyslab.platform.contacts.protocol.UniversalContactServerProtocol");
        PSDKModulesCustomization.registerProtocolCheckingClassName("Routing", "CustomServer", "com.genesyslab.platform.routing.protocol.UrsCustomProtocol");
        PSDKModulesCustomization.registerProtocolCheckingClassName("OpenMedia", "OpenMediaAttributes", "com.genesyslab.platform.openmedia.protocol.ExternalServiceProtocol");
        PSDKModulesCustomization.registerProtocolCheckingClassName("Outbound", "OutboundDesktop", "com.genesyslab.platform.outbound.protocol.OutboundServerProtocol");
        PSDKModulesCustomization.registerProtocolCheckingClassName("Voice", "PreviewInteraction", "com.genesyslab.platform.voice.protocol.TServerProtocol");
        PSDKModulesCustomization.registerProtocolConfigurator("ConfServer", new ConfServerModuleConfigurator());
        PSDKModulesCustomization.registerProtocolConfigurator("ContactServer", new ContactServerModuleConfigurator());
        PSDKModulesCustomization.registerProtocolConfigurator("TServer", new TServerModuleConfigurator());
        PSDKModulesCustomization.registerProtocolConfigurator("Email", new EmailModuleConfigurator());
        PSDKModulesCustomization.registerProtocolConfigurator("FlexChat", new FlexChatModuleConfigurator());
        PSDKModulesCustomization.registerProtocolConfigurator("BasicChat", new BasicChatModuleConfigurator());
        PSDKModulesCustomization.registerProtocolConfigurator("Callback", new CallbackModuleConfigurator());
        PSDKModulesCustomization.registerProtocolConfigurator("StatServer", new StatServerModuleConfigurator());
        PSDKModulesCustomization.registerProtocolConfigurator("SolutionControlServer", new SolutionControlServerModuleConfigurator());
        PSDKModulesCustomization.registerCategoryConfigurator("WebMedia", new WebMediaModuleConfigurator());
        PSDKModulesCustomization.registerCategoryConfigurator("Management", new ManagementModuleConfigurator());
    }

    static {
        PSDKModulesCustomization.init();
        customConfigurators = new PSDKModuleConfigurator(){

            @Override
            public void init(SimpleModule module) {
                for (PSDKModuleConfigurator cfg : registryCategoryConfigurators.values()) {
                    if (!cfg.isAvailable()) continue;
                    cfg.init(module);
                }
                for (PSDKModuleConfigurator cfg : registryProtocolConfigurators.values()) {
                    if (!cfg.isAvailable()) continue;
                    cfg.init(module);
                }
            }

            @Override
            public void setup(Module.SetupContext context) {
                for (PSDKModuleConfigurator cfg : registryCategoryConfigurators.values()) {
                    if (!cfg.isAvailable()) continue;
                    cfg.setup(context);
                }
                for (PSDKModuleConfigurator cfg : registryProtocolConfigurators.values()) {
                    if (!cfg.isAvailable()) continue;
                    cfg.setup(context);
                }
            }

            @Override
            public boolean isAvailable() {
                return true;
            }
        };
    }
}

