/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2.basicchat;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.json.jackson2.PSDKCommonModule;
import com.genesyslab.platform.json.jackson2.basicchat.ActionDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.ChatTranscriptDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.ChatTranscriptMixIn;
import com.genesyslab.platform.json.jackson2.basicchat.DescriptionDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.EventErrorDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.EventRegisteredDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.EventSessionInfoDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.MessageInfoDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.MessageInfoMixIn;
import com.genesyslab.platform.json.jackson2.basicchat.MessageTextDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.MsgCheckDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.NewPartyInfoDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.NewPartyInfoMixIn;
import com.genesyslab.platform.json.jackson2.basicchat.NoticeInfoDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.NoticeInfoMixIn;
import com.genesyslab.platform.json.jackson2.basicchat.NoticeTextDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.PartyLeftInfoDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.PartyLeftInfoMixIn;
import com.genesyslab.platform.json.jackson2.basicchat.ProtocolTypeDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.ReasonDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.ReasonMixIn;
import com.genesyslab.platform.json.jackson2.basicchat.ReenterInfoDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.ReenterInfoMixIn;
import com.genesyslab.platform.json.jackson2.basicchat.RequestJoinDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.RequestJoinMixIn;
import com.genesyslab.platform.json.jackson2.basicchat.RequestMessageDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.RequestNotifyDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.RequestRegisterDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.RequestRegisterMixIn;
import com.genesyslab.platform.json.jackson2.basicchat.RequestReleasePartyDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.SessionStatusDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.TreatAsDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.UserInfoDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.UserInfoMixIn;
import com.genesyslab.platform.json.jackson2.basicchat.UserStatusDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.UserTypeDeserializer;
import com.genesyslab.platform.json.jackson2.basicchat.VisibilityDeserializer;
import com.genesyslab.platform.json.jackson2.runtime.ProtocolUnknownMessageDeserializer;
import com.genesyslab.platform.webmedia.protocol.basicchat.Action;
import com.genesyslab.platform.webmedia.protocol.basicchat.BasicChatMessage;
import com.genesyslab.platform.webmedia.protocol.basicchat.BasicChatProtocolFactory;
import com.genesyslab.platform.webmedia.protocol.basicchat.ChatTranscript;
import com.genesyslab.platform.webmedia.protocol.basicchat.Description;
import com.genesyslab.platform.webmedia.protocol.basicchat.MessageInfo;
import com.genesyslab.platform.webmedia.protocol.basicchat.MessageText;
import com.genesyslab.platform.webmedia.protocol.basicchat.MsgCheck;
import com.genesyslab.platform.webmedia.protocol.basicchat.NewPartyInfo;
import com.genesyslab.platform.webmedia.protocol.basicchat.NoticeInfo;
import com.genesyslab.platform.webmedia.protocol.basicchat.NoticeText;
import com.genesyslab.platform.webmedia.protocol.basicchat.PartyLeftInfo;
import com.genesyslab.platform.webmedia.protocol.basicchat.ProtocolType;
import com.genesyslab.platform.webmedia.protocol.basicchat.Reason;
import com.genesyslab.platform.webmedia.protocol.basicchat.ReenterInfo;
import com.genesyslab.platform.webmedia.protocol.basicchat.SessionStatus;
import com.genesyslab.platform.webmedia.protocol.basicchat.TreatAs;
import com.genesyslab.platform.webmedia.protocol.basicchat.UserInfo;
import com.genesyslab.platform.webmedia.protocol.basicchat.UserStatus;
import com.genesyslab.platform.webmedia.protocol.basicchat.UserType;
import com.genesyslab.platform.webmedia.protocol.basicchat.Visibility;
import com.genesyslab.platform.webmedia.protocol.basicchat.events.EventError;
import com.genesyslab.platform.webmedia.protocol.basicchat.events.EventRegistered;
import com.genesyslab.platform.webmedia.protocol.basicchat.events.EventSessionInfo;
import com.genesyslab.platform.webmedia.protocol.basicchat.requests.RequestJoin;
import com.genesyslab.platform.webmedia.protocol.basicchat.requests.RequestMessage;
import com.genesyslab.platform.webmedia.protocol.basicchat.requests.RequestNotify;
import com.genesyslab.platform.webmedia.protocol.basicchat.requests.RequestRegister;
import com.genesyslab.platform.webmedia.protocol.basicchat.requests.RequestReleaseParty;
import java.io.IOException;

public class BasicChatModule
extends PSDKCommonModule {
    public BasicChatModule() {
        this(false);
    }

    public BasicChatModule(boolean enableMessageNameSerialization) {
        super("BasicChat", "WebMedia", Version.unknownVersion(), enableMessageNameSerialization);
        BasicChatModule.init(this);
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        BasicChatModule.setup(context);
    }

    public static void init(PSDKCommonModule module) {
        module.addDeserializer(ProtocolUnknownMessage.class, FactoryHolder.unknownMessageDeserializer);
        module.addDeserializer(Action.class, new ActionDeserializer());
        module.addDeserializer(UserType.class, new UserTypeDeserializer());
        module.addDeserializer(ProtocolType.class, new ProtocolTypeDeserializer());
        module.addDeserializer(UserStatus.class, new UserStatusDeserializer());
        module.addDeserializer(SessionStatus.class, new SessionStatusDeserializer());
        module.addDeserializer(Visibility.class, new VisibilityDeserializer());
        module.addDeserializer(TreatAs.class, new TreatAsDeserializer());
        module.addDeserializer(MsgCheck.class, new MsgCheckDeserializer());
        module.addDeserializer(RequestRegister.class, new RequestRegisterDeserializer());
        module.addDeserializer(RequestJoin.class, new RequestJoinDeserializer());
        module.addDeserializer(RequestReleaseParty.class, new RequestReleasePartyDeserializer());
        module.addDeserializer(RequestMessage.class, new RequestMessageDeserializer());
        module.addDeserializer(RequestNotify.class, new RequestNotifyDeserializer());
        module.addDeserializer(EventRegistered.class, new EventRegisteredDeserializer());
        module.addDeserializer(EventSessionInfo.class, new EventSessionInfoDeserializer());
        module.addDeserializer(EventError.class, new EventErrorDeserializer());
        module.addDeserializer(Description.class, new DescriptionDeserializer());
        module.addDeserializer(Reason.class, new ReasonDeserializer());
        module.addDeserializer(MessageText.class, new MessageTextDeserializer());
        module.addDeserializer(NoticeText.class, new NoticeTextDeserializer());
        module.addDeserializer(ChatTranscript.class, new ChatTranscriptDeserializer());
        module.addDeserializer(UserInfo.class, new UserInfoDeserializer());
        module.addDeserializer(NewPartyInfo.class, new NewPartyInfoDeserializer());
        module.addDeserializer(PartyLeftInfo.class, new PartyLeftInfoDeserializer());
        module.addDeserializer(ReenterInfo.class, new ReenterInfoDeserializer());
        module.addDeserializer(MessageInfo.class, new MessageInfoDeserializer());
        module.addDeserializer(NoticeInfo.class, new NoticeInfoDeserializer());
        if (module instanceof BasicChatModule) {
            module.addDeserializer(BasicChatMessage.class, (JsonDeserializer)new JsonDeserializer<BasicChatMessage>(){

                public BasicChatMessage deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    String messageNameKey = "messageName";
                    PropertyNamingStrategy strategy = ((ObjectMapper)jp.getCodec()).getDeserializationConfig().getPropertyNamingStrategy();
                    if (strategy instanceof PropertyNamingStrategy.PropertyNamingStrategyBase) {
                        PropertyNamingStrategy.PropertyNamingStrategyBase base = (PropertyNamingStrategy.PropertyNamingStrategyBase)strategy;
                        messageNameKey = base.translate(messageNameKey);
                    }
                    String messageName = null;
                    if (JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                        jp.nextToken();
                    }
                    if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                        throw new JsonParseException("The attribute name is expected", jp.getCurrentLocation());
                    }
                    TokenBuffer tb = new TokenBuffer(null, false);
                    tb.writeStartObject();
                    String keyName = jp.getText();
                    if (messageNameKey.equals(keyName)) {
                        if (!JsonToken.VALUE_STRING.equals((Object)jp.nextToken())) {
                            throw new JsonParseException("The text attribute '" + messageNameKey + "' is expected at the begin of json", jp.getCurrentLocation());
                        }
                        messageName = jp.getText();
                    } else {
                        JsonToken t = jp.getCurrentToken();
                        while (t == JsonToken.FIELD_NAME) {
                            String name = jp.getCurrentName();
                            jp.nextToken();
                            if (messageNameKey.equals(name)) {
                                messageName = jp.getText();
                                jp.nextToken();
                                break;
                            }
                            tb.writeFieldName(name);
                            tb.copyCurrentStructure(jp);
                            t = jp.nextToken();
                        }
                    }
                    jp = JsonParserSequence.createFlattened((JsonParser)tb.asParser(jp), (JsonParser)jp);
                    jp.nextToken();
                    if (messageName != null) {
                        ProtocolUnknownMessage msg;
                        if ("ProtocolUnknownMessage".equals(messageName)) {
                            msg = FactoryHolder.unknownMessageDeserializer.deserialize(jp, ctxt);
                        } else {
                            Class c = FactoryHolder.protocolFactory.getMessageClass(messageName);
                            msg = (Message)jp.getCodec().readValue(jp, c);
                        }
                        return (BasicChatMessage)msg;
                    }
                    throw new JsonParseException("The attribute '" + messageNameKey + "' is expected (it should be the first JSON attribute)", jp.getCurrentLocation());
                }
            });
        }
    }

    public static void setup(Module.SetupContext context) {
        context.setMixInAnnotations(Reason.class, ReasonMixIn.class);
        context.setMixInAnnotations(ChatTranscript.class, ChatTranscriptMixIn.class);
        context.setMixInAnnotations(UserInfo.class, UserInfoMixIn.class);
        context.setMixInAnnotations(NewPartyInfo.class, NewPartyInfoMixIn.class);
        context.setMixInAnnotations(PartyLeftInfo.class, PartyLeftInfoMixIn.class);
        context.setMixInAnnotations(ReenterInfo.class, ReenterInfoMixIn.class);
        context.setMixInAnnotations(MessageInfo.class, MessageInfoMixIn.class);
        context.setMixInAnnotations(NoticeInfo.class, NoticeInfoMixIn.class);
        context.setMixInAnnotations(RequestRegister.class, RequestRegisterMixIn.class);
        context.setMixInAnnotations(RequestJoin.class, RequestJoinMixIn.class);
    }

    public static boolean isAvailable() {
        return PSDKCommonModule.isProtocolAvailable("WebMedia", "BasicChat");
    }

    @Override
    public Class<?> getMarkerClass() {
        return BasicChatMessage.class;
    }

    @Override
    public Class<? extends Message> getMessageClass(String name) {
        return FactoryHolder.protocolFactory.getMessageClass(name);
    }

    @Override
    public ProtocolUnknownMessage createUnknownMessage(int messageId) {
        return FactoryHolder.protocolFactory.unknownProtocolMessage(messageId);
    }

    private static class FactoryHolder
    extends BasicChatProtocolFactory {
        private static final FactoryHolder protocolFactory = new FactoryHolder();
        private static final ProtocolUnknownMessageDeserializer unknownMessageDeserializer = new ProtocolUnknownMessageDeserializer((AbstractProtocolFactory)protocolFactory);

        private FactoryHolder() {
        }

        public ProtocolUnknownMessage unknownProtocolMessage(int messageId) {
            return (ProtocolUnknownMessage)super.unknownProtocolMessage(messageId);
        }
    }
}

