/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2.espemail;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.json.jackson2.PSDKCommonModule;
import com.genesyslab.platform.json.jackson2.espemail.ErrorCodesDeserializer;
import com.genesyslab.platform.json.jackson2.runtime.ProtocolUnknownMessageDeserializer;
import com.genesyslab.platform.webmedia.protocol.espemail.ErrorCodes;
import com.genesyslab.platform.webmedia.protocol.espemail.EspEmailMessage;
import com.genesyslab.platform.webmedia.protocol.espemail.EspEmailProtocolFactory;
import java.io.IOException;

public class EspEmailModule
extends PSDKCommonModule {
    public EspEmailModule() {
        this(false);
    }

    public EspEmailModule(boolean enableMessageNameSerialization) {
        super("EspEmail", "WebMedia", Version.unknownVersion(), enableMessageNameSerialization);
        EspEmailModule.init(this);
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        EspEmailModule.setup(context);
    }

    public static void init(PSDKCommonModule module) {
        module.addDeserializer(ProtocolUnknownMessage.class, FactoryHolder.unknownMessageDeserializer);
        module.addDeserializer(ErrorCodes.class, new ErrorCodesDeserializer());
        if (module instanceof EspEmailModule) {
            module.addDeserializer(EspEmailMessage.class, (JsonDeserializer)new JsonDeserializer<EspEmailMessage>(){

                public EspEmailMessage deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    String messageNameKey = "messageName";
                    PropertyNamingStrategy strategy = ((ObjectMapper)jp.getCodec()).getDeserializationConfig().getPropertyNamingStrategy();
                    if (strategy instanceof PropertyNamingStrategy.PropertyNamingStrategyBase) {
                        PropertyNamingStrategy.PropertyNamingStrategyBase base = (PropertyNamingStrategy.PropertyNamingStrategyBase)strategy;
                        messageNameKey = base.translate(messageNameKey);
                    }
                    String messageName = null;
                    if (JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                        jp.nextToken();
                    }
                    if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                        throw new JsonParseException("The attribute name is expected", jp.getCurrentLocation());
                    }
                    TokenBuffer tb = new TokenBuffer(null, false);
                    tb.writeStartObject();
                    String keyName = jp.getText();
                    if (messageNameKey.equals(keyName)) {
                        if (!JsonToken.VALUE_STRING.equals((Object)jp.nextToken())) {
                            throw new JsonParseException("The text attribute '" + messageNameKey + "' is expected at the begin of json", jp.getCurrentLocation());
                        }
                        messageName = jp.getText();
                    } else {
                        JsonToken t = jp.getCurrentToken();
                        while (t == JsonToken.FIELD_NAME) {
                            String name = jp.getCurrentName();
                            jp.nextToken();
                            if (messageNameKey.equals(name)) {
                                messageName = jp.getText();
                                jp.nextToken();
                                break;
                            }
                            tb.writeFieldName(name);
                            tb.copyCurrentStructure(jp);
                            t = jp.nextToken();
                        }
                    }
                    jp = JsonParserSequence.createFlattened((JsonParser)tb.asParser(jp), (JsonParser)jp);
                    jp.nextToken();
                    if (messageName != null) {
                        ProtocolUnknownMessage msg;
                        if ("ProtocolUnknownMessage".equals(messageName)) {
                            msg = FactoryHolder.unknownMessageDeserializer.deserialize(jp, ctxt);
                        } else {
                            Class c = FactoryHolder.protocolFactory.getMessageClass(messageName);
                            msg = (Message)jp.getCodec().readValue(jp, c);
                        }
                        return (EspEmailMessage)msg;
                    }
                    throw new JsonParseException("The attribute '" + messageNameKey + "' is expected (it should be the first JSON attribute)", jp.getCurrentLocation());
                }
            });
        }
    }

    public static void setup(Module.SetupContext context) {
    }

    public static boolean isAvailable() {
        return PSDKCommonModule.isProtocolAvailable("WebMedia", "EspEmail");
    }

    @Override
    public Class<?> getMarkerClass() {
        return EspEmailMessage.class;
    }

    @Override
    public Class<? extends Message> getMessageClass(String name) {
        return FactoryHolder.protocolFactory.getMessageClass(name);
    }

    @Override
    public ProtocolUnknownMessage createUnknownMessage(int messageId) {
        return FactoryHolder.protocolFactory.unknownProtocolMessage(messageId);
    }

    private static class FactoryHolder
    extends EspEmailProtocolFactory {
        private static final FactoryHolder protocolFactory = new FactoryHolder();
        private static final ProtocolUnknownMessageDeserializer unknownMessageDeserializer = new ProtocolUnknownMessageDeserializer((AbstractProtocolFactory)protocolFactory);

        private FactoryHolder() {
        }

        public ProtocolUnknownMessage unknownProtocolMessage(int messageId) {
            return (ProtocolUnknownMessage)super.unknownProtocolMessage(messageId);
        }
    }
}

