/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2.flexchat;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.json.jackson2.PSDKCommonModule;
import com.genesyslab.platform.json.jackson2.flexchat.DescriptionDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.EventInfoDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.EventInfoMixIn;
import com.genesyslab.platform.json.jackson2.flexchat.EventStatusDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.EventStatusMixIn;
import com.genesyslab.platform.json.jackson2.flexchat.EventTypeDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.FlexTranscriptDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.FlexTranscriptMixIn;
import com.genesyslab.platform.json.jackson2.flexchat.MessageTextDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.MsgCheckDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.NoticeTextDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.RequestJoinDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.RequestJoinMixIn;
import com.genesyslab.platform.json.jackson2.flexchat.RequestLoginDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.RequestLoginMixIn;
import com.genesyslab.platform.json.jackson2.flexchat.RequestLogoutDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.RequestLogoutMixIn;
import com.genesyslab.platform.json.jackson2.flexchat.RequestRefreshDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.RequestRefreshMixIn;
import com.genesyslab.platform.json.jackson2.flexchat.RequestResultDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.TreatAsDeserializer;
import com.genesyslab.platform.json.jackson2.flexchat.UserTypeDeserializer;
import com.genesyslab.platform.json.jackson2.runtime.ProtocolUnknownMessageDeserializer;
import com.genesyslab.platform.webmedia.protocol.flexchat.Description;
import com.genesyslab.platform.webmedia.protocol.flexchat.EventInfo;
import com.genesyslab.platform.webmedia.protocol.flexchat.EventType;
import com.genesyslab.platform.webmedia.protocol.flexchat.FlexChatMessage;
import com.genesyslab.platform.webmedia.protocol.flexchat.FlexChatProtocolFactory;
import com.genesyslab.platform.webmedia.protocol.flexchat.FlexTranscript;
import com.genesyslab.platform.webmedia.protocol.flexchat.MessageText;
import com.genesyslab.platform.webmedia.protocol.flexchat.MsgCheck;
import com.genesyslab.platform.webmedia.protocol.flexchat.NoticeText;
import com.genesyslab.platform.webmedia.protocol.flexchat.RequestResult;
import com.genesyslab.platform.webmedia.protocol.flexchat.TreatAs;
import com.genesyslab.platform.webmedia.protocol.flexchat.UserType;
import com.genesyslab.platform.webmedia.protocol.flexchat.events.EventStatus;
import com.genesyslab.platform.webmedia.protocol.flexchat.requests.RequestJoin;
import com.genesyslab.platform.webmedia.protocol.flexchat.requests.RequestLogin;
import com.genesyslab.platform.webmedia.protocol.flexchat.requests.RequestLogout;
import com.genesyslab.platform.webmedia.protocol.flexchat.requests.RequestRefresh;
import java.io.IOException;

public class FlexChatModule
extends PSDKCommonModule {
    public FlexChatModule() {
        this(false);
    }

    public FlexChatModule(boolean enableMessageNameSerialization) {
        super("FlexChat", "WebMedia", Version.unknownVersion(), enableMessageNameSerialization);
        FlexChatModule.init(this);
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        FlexChatModule.setup(context);
    }

    public static void init(PSDKCommonModule module) {
        module.addDeserializer(ProtocolUnknownMessage.class, FactoryHolder.unknownMessageDeserializer);
        module.addDeserializer(UserType.class, new UserTypeDeserializer());
        module.addDeserializer(EventType.class, new EventTypeDeserializer());
        module.addDeserializer(MsgCheck.class, new MsgCheckDeserializer());
        module.addDeserializer(RequestResult.class, new RequestResultDeserializer());
        module.addDeserializer(TreatAs.class, new TreatAsDeserializer());
        module.addDeserializer(RequestLogin.class, new RequestLoginDeserializer());
        module.addDeserializer(RequestJoin.class, new RequestJoinDeserializer());
        module.addDeserializer(RequestRefresh.class, new RequestRefreshDeserializer());
        module.addDeserializer(RequestLogout.class, new RequestLogoutDeserializer());
        module.addDeserializer(EventStatus.class, new EventStatusDeserializer());
        module.addDeserializer(Description.class, new DescriptionDeserializer());
        module.addDeserializer(MessageText.class, new MessageTextDeserializer());
        module.addDeserializer(NoticeText.class, new NoticeTextDeserializer());
        module.addDeserializer(FlexTranscript.class, new FlexTranscriptDeserializer());
        module.addDeserializer(EventInfo.class, new EventInfoDeserializer());
        if (module instanceof FlexChatModule) {
            module.addDeserializer(FlexChatMessage.class, (JsonDeserializer)new JsonDeserializer<FlexChatMessage>(){

                public FlexChatMessage deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    String messageNameKey = "messageName";
                    PropertyNamingStrategy strategy = ((ObjectMapper)jp.getCodec()).getDeserializationConfig().getPropertyNamingStrategy();
                    if (strategy instanceof PropertyNamingStrategy.PropertyNamingStrategyBase) {
                        PropertyNamingStrategy.PropertyNamingStrategyBase base = (PropertyNamingStrategy.PropertyNamingStrategyBase)strategy;
                        messageNameKey = base.translate(messageNameKey);
                    }
                    String messageName = null;
                    if (JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                        jp.nextToken();
                    }
                    if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                        throw new JsonParseException("The attribute name is expected", jp.getCurrentLocation());
                    }
                    TokenBuffer tb = new TokenBuffer(null, false);
                    tb.writeStartObject();
                    String keyName = jp.getText();
                    if (messageNameKey.equals(keyName)) {
                        if (!JsonToken.VALUE_STRING.equals((Object)jp.nextToken())) {
                            throw new JsonParseException("The text attribute '" + messageNameKey + "' is expected at the begin of json", jp.getCurrentLocation());
                        }
                        messageName = jp.getText();
                    } else {
                        JsonToken t = jp.getCurrentToken();
                        while (t == JsonToken.FIELD_NAME) {
                            String name = jp.getCurrentName();
                            jp.nextToken();
                            if (messageNameKey.equals(name)) {
                                messageName = jp.getText();
                                jp.nextToken();
                                break;
                            }
                            tb.writeFieldName(name);
                            tb.copyCurrentStructure(jp);
                            t = jp.nextToken();
                        }
                    }
                    jp = JsonParserSequence.createFlattened((JsonParser)tb.asParser(jp), (JsonParser)jp);
                    jp.nextToken();
                    if (messageName != null) {
                        ProtocolUnknownMessage msg;
                        if ("ProtocolUnknownMessage".equals(messageName)) {
                            msg = FactoryHolder.unknownMessageDeserializer.deserialize(jp, ctxt);
                        } else {
                            Class c = FactoryHolder.protocolFactory.getMessageClass(messageName);
                            msg = (Message)jp.getCodec().readValue(jp, c);
                        }
                        return (FlexChatMessage)msg;
                    }
                    throw new JsonParseException("The attribute '" + messageNameKey + "' is expected (it should be the first JSON attribute)", jp.getCurrentLocation());
                }
            });
        }
    }

    public static void setup(Module.SetupContext context) {
        context.setMixInAnnotations(FlexTranscript.class, FlexTranscriptMixIn.class);
        context.setMixInAnnotations(EventInfo.class, EventInfoMixIn.class);
        context.setMixInAnnotations(RequestLogin.class, RequestLoginMixIn.class);
        context.setMixInAnnotations(RequestJoin.class, RequestJoinMixIn.class);
        context.setMixInAnnotations(RequestRefresh.class, RequestRefreshMixIn.class);
        context.setMixInAnnotations(RequestLogout.class, RequestLogoutMixIn.class);
        context.setMixInAnnotations(EventStatus.class, EventStatusMixIn.class);
    }

    public static boolean isAvailable() {
        return PSDKCommonModule.isProtocolAvailable("WebMedia", "FlexChat");
    }

    @Override
    public Class<?> getMarkerClass() {
        return FlexChatMessage.class;
    }

    @Override
    public Class<? extends Message> getMessageClass(String name) {
        return FactoryHolder.protocolFactory.getMessageClass(name);
    }

    @Override
    public ProtocolUnknownMessage createUnknownMessage(int messageId) {
        return FactoryHolder.protocolFactory.unknownProtocolMessage(messageId);
    }

    private static class FactoryHolder
    extends FlexChatProtocolFactory {
        private static final FactoryHolder protocolFactory = new FactoryHolder();
        private static final ProtocolUnknownMessageDeserializer unknownMessageDeserializer = new ProtocolUnknownMessageDeserializer((AbstractProtocolFactory)protocolFactory);

        private FactoryHolder() {
        }

        public ProtocolUnknownMessage unknownProtocolMessage(int messageId) {
            return (ProtocolUnknownMessage)super.unknownProtocolMessage(messageId);
        }
    }
}

