/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2.messageserver;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.json.jackson2.PSDKCommonModule;
import com.genesyslab.platform.json.jackson2.messageserver.EventConnectedDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.EventConnectedMixIn;
import com.genesyslab.platform.json.jackson2.messageserver.EventDisconnectedDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.EventDisconnectedMixIn;
import com.genesyslab.platform.json.jackson2.messageserver.EventErrorDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.EventErrorMixIn;
import com.genesyslab.platform.json.jackson2.messageserver.EventLogMessageDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.EventLogMessageMixIn;
import com.genesyslab.platform.json.jackson2.messageserver.EventSubscriptionDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.EventSubscriptionMixIn;
import com.genesyslab.platform.json.jackson2.messageserver.KeyFlagsDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.LogCategoryDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.LogDataFormatDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.LogLevelDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.MessageKeyDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.MessageKeyMixIn;
import com.genesyslab.platform.json.jackson2.messageserver.MessagePriorityDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.MessageTypesDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.RequestConnectDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.RequestLogMessageDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.RequestLogMessageMixIn;
import com.genesyslab.platform.json.jackson2.messageserver.RequestSubscribeAllDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.RequestSubscribeTypeDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.RequestSubscribeTypeKeyDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.RequestSubscribeTypeKeyMixIn;
import com.genesyslab.platform.json.jackson2.messageserver.RequestSubscribeTypeMixIn;
import com.genesyslab.platform.json.jackson2.messageserver.RequestUnsubscribeAllDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.RequestUnsubscribeTypeDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.RequestUnsubscribeTypeKeyDeserializer;
import com.genesyslab.platform.json.jackson2.messageserver.RequestUnsubscribeTypeKeyMixIn;
import com.genesyslab.platform.json.jackson2.messageserver.RequestUnsubscribeTypeMixIn;
import com.genesyslab.platform.json.jackson2.runtime.ProtocolUnknownMessageDeserializer;
import com.genesyslab.platform.management.protocol.messageserver.KeyFlags;
import com.genesyslab.platform.management.protocol.messageserver.LogCategory;
import com.genesyslab.platform.management.protocol.messageserver.LogDataFormat;
import com.genesyslab.platform.management.protocol.messageserver.LogLevel;
import com.genesyslab.platform.management.protocol.messageserver.MessageKey;
import com.genesyslab.platform.management.protocol.messageserver.MessagePriority;
import com.genesyslab.platform.management.protocol.messageserver.MessageServerMessage;
import com.genesyslab.platform.management.protocol.messageserver.MessageTypes;
import com.genesyslab.platform.management.protocol.messageserver.events.EventConnected;
import com.genesyslab.platform.management.protocol.messageserver.events.EventError;
import com.genesyslab.platform.management.protocol.messageserver.events.EventLogMessage;
import com.genesyslab.platform.management.protocol.messageserver.events.EventSubscription;
import com.genesyslab.platform.management.protocol.messageserver.requests.RequestLogMessage;
import com.genesyslab.platform.management.protocol.messageserver.requests.subscription.RequestSubscribeAll;
import com.genesyslab.platform.management.protocol.messageserver.requests.subscription.RequestSubscribeType;
import com.genesyslab.platform.management.protocol.messageserver.requests.subscription.RequestSubscribeTypeKey;
import com.genesyslab.platform.management.protocol.messageserver.requests.subscription.RequestUnsubscribeAll;
import com.genesyslab.platform.management.protocol.messageserver.requests.subscription.RequestUnsubscribeType;
import com.genesyslab.platform.management.protocol.messageserver.requests.subscription.RequestUnsubscribeTypeKey;
import com.genesyslab.platform.management.protocol.messageserver.runtime.MessageServerInternalProtocolFactory;
import com.genesyslab.platform.management.protocol.messageserver.runtime.channel.EventDisconnected;
import com.genesyslab.platform.management.protocol.messageserver.runtime.channel.RequestConnect;
import java.io.IOException;

public class MessageServerModule
extends PSDKCommonModule {
    public MessageServerModule() {
        this(false);
    }

    public MessageServerModule(boolean enableMessageNameSerialization) {
        super("MessageServer", "Management", Version.unknownVersion(), enableMessageNameSerialization);
        MessageServerModule.init(this);
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        MessageServerModule.setup(context);
    }

    public static void init(PSDKCommonModule module) {
        module.addDeserializer(ProtocolUnknownMessage.class, FactoryHolder.unknownMessageDeserializer);
        module.addDeserializer(LogLevel.class, new LogLevelDeserializer());
        module.addDeserializer(KeyFlags.class, new KeyFlagsDeserializer());
        module.addDeserializer(LogDataFormat.class, new LogDataFormatDeserializer());
        module.addDeserializer(MessageTypes.class, new MessageTypesDeserializer());
        module.addDeserializer(LogCategory.class, new LogCategoryDeserializer());
        module.addDeserializer(MessagePriority.class, new MessagePriorityDeserializer());
        module.addDeserializer(RequestLogMessage.class, new RequestLogMessageDeserializer());
        module.addDeserializer(RequestConnect.class, new RequestConnectDeserializer());
        module.addDeserializer(RequestSubscribeAll.class, new RequestSubscribeAllDeserializer());
        module.addDeserializer(RequestSubscribeType.class, new RequestSubscribeTypeDeserializer());
        module.addDeserializer(RequestSubscribeTypeKey.class, new RequestSubscribeTypeKeyDeserializer());
        module.addDeserializer(RequestUnsubscribeAll.class, new RequestUnsubscribeAllDeserializer());
        module.addDeserializer(RequestUnsubscribeType.class, new RequestUnsubscribeTypeDeserializer());
        module.addDeserializer(RequestUnsubscribeTypeKey.class, new RequestUnsubscribeTypeKeyDeserializer());
        module.addDeserializer(EventSubscription.class, new EventSubscriptionDeserializer());
        module.addDeserializer(EventError.class, new EventErrorDeserializer());
        module.addDeserializer(EventConnected.class, new EventConnectedDeserializer());
        module.addDeserializer(EventDisconnected.class, new EventDisconnectedDeserializer());
        module.addDeserializer(EventLogMessage.class, new EventLogMessageDeserializer());
        module.addDeserializer(MessageKey.class, new MessageKeyDeserializer());
        if (module instanceof MessageServerModule) {
            module.addDeserializer(MessageServerMessage.class, (JsonDeserializer)new JsonDeserializer<MessageServerMessage>(){

                public MessageServerMessage deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    String messageNameKey = "messageName";
                    PropertyNamingStrategy strategy = ((ObjectMapper)jp.getCodec()).getDeserializationConfig().getPropertyNamingStrategy();
                    if (strategy instanceof PropertyNamingStrategy.PropertyNamingStrategyBase) {
                        PropertyNamingStrategy.PropertyNamingStrategyBase base = (PropertyNamingStrategy.PropertyNamingStrategyBase)strategy;
                        messageNameKey = base.translate(messageNameKey);
                    }
                    String messageName = null;
                    if (JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                        jp.nextToken();
                    }
                    if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                        throw new JsonParseException("The attribute name is expected", jp.getCurrentLocation());
                    }
                    TokenBuffer tb = new TokenBuffer(null, false);
                    tb.writeStartObject();
                    String keyName = jp.getText();
                    if (messageNameKey.equals(keyName)) {
                        if (!JsonToken.VALUE_STRING.equals((Object)jp.nextToken())) {
                            throw new JsonParseException("The text attribute '" + messageNameKey + "' is expected at the begin of json", jp.getCurrentLocation());
                        }
                        messageName = jp.getText();
                    } else {
                        JsonToken t = jp.getCurrentToken();
                        while (t == JsonToken.FIELD_NAME) {
                            String name = jp.getCurrentName();
                            jp.nextToken();
                            if (messageNameKey.equals(name)) {
                                messageName = jp.getText();
                                jp.nextToken();
                                break;
                            }
                            tb.writeFieldName(name);
                            tb.copyCurrentStructure(jp);
                            t = jp.nextToken();
                        }
                    }
                    jp = JsonParserSequence.createFlattened((JsonParser)tb.asParser(jp), (JsonParser)jp);
                    jp.nextToken();
                    if (messageName != null) {
                        ProtocolUnknownMessage msg;
                        if ("ProtocolUnknownMessage".equals(messageName)) {
                            msg = FactoryHolder.unknownMessageDeserializer.deserialize(jp, ctxt);
                        } else {
                            Class c = FactoryHolder.protocolFactory.getMessageClass(messageName);
                            msg = (Message)jp.getCodec().readValue(jp, c);
                        }
                        return (MessageServerMessage)msg;
                    }
                    throw new JsonParseException("The attribute '" + messageNameKey + "' is expected (it should be the first JSON attribute)", jp.getCurrentLocation());
                }
            });
        }
    }

    public static void setup(Module.SetupContext context) {
        context.setMixInAnnotations(MessageKey.class, MessageKeyMixIn.class);
        context.setMixInAnnotations(RequestLogMessage.class, RequestLogMessageMixIn.class);
        context.setMixInAnnotations(RequestSubscribeType.class, RequestSubscribeTypeMixIn.class);
        context.setMixInAnnotations(RequestSubscribeTypeKey.class, RequestSubscribeTypeKeyMixIn.class);
        context.setMixInAnnotations(RequestUnsubscribeType.class, RequestUnsubscribeTypeMixIn.class);
        context.setMixInAnnotations(RequestUnsubscribeTypeKey.class, RequestUnsubscribeTypeKeyMixIn.class);
        context.setMixInAnnotations(EventSubscription.class, EventSubscriptionMixIn.class);
        context.setMixInAnnotations(EventError.class, EventErrorMixIn.class);
        context.setMixInAnnotations(EventConnected.class, EventConnectedMixIn.class);
        context.setMixInAnnotations(EventDisconnected.class, EventDisconnectedMixIn.class);
        context.setMixInAnnotations(EventLogMessage.class, EventLogMessageMixIn.class);
    }

    public static boolean isAvailable() {
        return PSDKCommonModule.isProtocolAvailable("Management", "MessageServer");
    }

    @Override
    public Class<?> getMarkerClass() {
        return MessageServerMessage.class;
    }

    @Override
    public Class<? extends Message> getMessageClass(String name) {
        return FactoryHolder.protocolFactory.getMessageClass(name);
    }

    @Override
    public ProtocolUnknownMessage createUnknownMessage(int messageId) {
        return FactoryHolder.protocolFactory.unknownProtocolMessage(messageId);
    }

    private static class FactoryHolder
    extends MessageServerInternalProtocolFactory {
        private static final FactoryHolder protocolFactory = new FactoryHolder();
        private static final ProtocolUnknownMessageDeserializer unknownMessageDeserializer = new ProtocolUnknownMessageDeserializer((AbstractProtocolFactory)protocolFactory);

        private FactoryHolder() {
        }

        public ProtocolUnknownMessage unknownProtocolMessage(int messageId) {
            return (ProtocolUnknownMessage)super.unknownProtocolMessage(messageId);
        }
    }
}

