/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2.routingserver;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.json.jackson2.PSDKCommonModule;
import com.genesyslab.platform.json.jackson2.routingserver.CallTypeDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.ClientTypeDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.ErrorCodeDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.EventDebugDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.EventErrorDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.EventErrorMixIn;
import com.genesyslab.platform.json.jackson2.routingserver.EventExecutionAckDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.EventExecutionAckMixIn;
import com.genesyslab.platform.json.jackson2.routingserver.EventExecutionErrorDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.EventExecutionErrorMixIn;
import com.genesyslab.platform.json.jackson2.routingserver.EventExecutionInProgressDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.EventInfoDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.EventInfoMixIn;
import com.genesyslab.platform.json.jackson2.routingserver.EventOpenOKDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.EventOpenOKMixIn;
import com.genesyslab.platform.json.jackson2.routingserver.OperationContextDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RequestCancelExecutionDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RequestCancelExecutionMixIn;
import com.genesyslab.platform.json.jackson2.routingserver.RequestDebugDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RequestExecuteDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RequestExecuteStrategyDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RequestFindTargetDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RequestFindTargetMixIn;
import com.genesyslab.platform.json.jackson2.routingserver.RequestGetStatisticDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RequestLoadStrategyDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RequestNotifyDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RequestQueryExecutionDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RequestQueryExecutionMixIn;
import com.genesyslab.platform.json.jackson2.routingserver.RequestRegisterClientDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RequestReleaseStrategyDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RequestUnregisterClientDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.RoutingPointStatusDeserializer;
import com.genesyslab.platform.json.jackson2.routingserver.StatisticUsageDeserializer;
import com.genesyslab.platform.json.jackson2.runtime.ProtocolUnknownMessageDeserializer;
import com.genesyslab.platform.routing.protocol.routingserver.CallType;
import com.genesyslab.platform.routing.protocol.routingserver.ClientType;
import com.genesyslab.platform.routing.protocol.routingserver.ErrorCode;
import com.genesyslab.platform.routing.protocol.routingserver.OperationContext;
import com.genesyslab.platform.routing.protocol.routingserver.RoutingPointStatus;
import com.genesyslab.platform.routing.protocol.routingserver.RoutingServerMessage;
import com.genesyslab.platform.routing.protocol.routingserver.StatisticUsage;
import com.genesyslab.platform.routing.protocol.routingserver.events.EventDebug;
import com.genesyslab.platform.routing.protocol.routingserver.events.EventError;
import com.genesyslab.platform.routing.protocol.routingserver.events.EventExecutionAck;
import com.genesyslab.platform.routing.protocol.routingserver.events.EventExecutionError;
import com.genesyslab.platform.routing.protocol.routingserver.events.EventExecutionInProgress;
import com.genesyslab.platform.routing.protocol.routingserver.events.EventInfo;
import com.genesyslab.platform.routing.protocol.routingserver.requests.RequestCancelExecution;
import com.genesyslab.platform.routing.protocol.routingserver.requests.RequestDebug;
import com.genesyslab.platform.routing.protocol.routingserver.requests.RequestExecuteStrategy;
import com.genesyslab.platform.routing.protocol.routingserver.requests.RequestFindTarget;
import com.genesyslab.platform.routing.protocol.routingserver.requests.RequestGetStatistic;
import com.genesyslab.platform.routing.protocol.routingserver.requests.RequestLoadStrategy;
import com.genesyslab.platform.routing.protocol.routingserver.requests.RequestNotify;
import com.genesyslab.platform.routing.protocol.routingserver.requests.RequestQueryExecution;
import com.genesyslab.platform.routing.protocol.routingserver.requests.RequestReleaseStrategy;
import com.genesyslab.platform.routing.protocol.routingserver.runtime.RoutingServerInternalProtocolFactory;
import com.genesyslab.platform.routing.protocol.routingserver.runtime.channel.EventOpenOK;
import com.genesyslab.platform.routing.protocol.routingserver.runtime.channel.RequestExecute;
import com.genesyslab.platform.routing.protocol.routingserver.runtime.channel.RequestRegisterClient;
import com.genesyslab.platform.routing.protocol.routingserver.runtime.channel.RequestUnregisterClient;
import java.io.IOException;

public class RoutingServerModule
extends PSDKCommonModule {
    public RoutingServerModule() {
        this(false);
    }

    public RoutingServerModule(boolean enableMessageNameSerialization) {
        super("RoutingServer", "Routing", Version.unknownVersion(), enableMessageNameSerialization);
        RoutingServerModule.init(this);
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        RoutingServerModule.setup(context);
    }

    public static void init(PSDKCommonModule module) {
        module.addDeserializer(ProtocolUnknownMessage.class, FactoryHolder.unknownMessageDeserializer);
        module.addDeserializer(ClientType.class, new ClientTypeDeserializer());
        module.addDeserializer(ErrorCode.class, new ErrorCodeDeserializer());
        module.addDeserializer(CallType.class, new CallTypeDeserializer());
        module.addDeserializer(RoutingPointStatus.class, new RoutingPointStatusDeserializer());
        module.addDeserializer(StatisticUsage.class, new StatisticUsageDeserializer());
        module.addDeserializer(RequestRegisterClient.class, new RequestRegisterClientDeserializer());
        module.addDeserializer(RequestUnregisterClient.class, new RequestUnregisterClientDeserializer());
        module.addDeserializer(RequestLoadStrategy.class, new RequestLoadStrategyDeserializer());
        module.addDeserializer(RequestReleaseStrategy.class, new RequestReleaseStrategyDeserializer());
        module.addDeserializer(RequestNotify.class, new RequestNotifyDeserializer());
        module.addDeserializer(RequestExecute.class, new RequestExecuteDeserializer());
        module.addDeserializer(RequestDebug.class, new RequestDebugDeserializer());
        module.addDeserializer(RequestExecuteStrategy.class, new RequestExecuteStrategyDeserializer());
        module.addDeserializer(RequestFindTarget.class, new RequestFindTargetDeserializer());
        module.addDeserializer(RequestGetStatistic.class, new RequestGetStatisticDeserializer());
        module.addDeserializer(RequestCancelExecution.class, new RequestCancelExecutionDeserializer());
        module.addDeserializer(RequestQueryExecution.class, new RequestQueryExecutionDeserializer());
        module.addDeserializer(EventError.class, new EventErrorDeserializer());
        module.addDeserializer(EventInfo.class, new EventInfoDeserializer());
        module.addDeserializer(EventOpenOK.class, new EventOpenOKDeserializer());
        module.addDeserializer(EventExecutionInProgress.class, new EventExecutionInProgressDeserializer());
        module.addDeserializer(EventExecutionAck.class, new EventExecutionAckDeserializer());
        module.addDeserializer(EventExecutionError.class, new EventExecutionErrorDeserializer());
        module.addDeserializer(EventDebug.class, new EventDebugDeserializer());
        module.addDeserializer(OperationContext.class, new OperationContextDeserializer());
        if (module instanceof RoutingServerModule) {
            module.addDeserializer(RoutingServerMessage.class, (JsonDeserializer)new JsonDeserializer<RoutingServerMessage>(){

                public RoutingServerMessage deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    String messageNameKey = "messageName";
                    PropertyNamingStrategy strategy = ((ObjectMapper)jp.getCodec()).getDeserializationConfig().getPropertyNamingStrategy();
                    if (strategy instanceof PropertyNamingStrategy.PropertyNamingStrategyBase) {
                        PropertyNamingStrategy.PropertyNamingStrategyBase base = (PropertyNamingStrategy.PropertyNamingStrategyBase)strategy;
                        messageNameKey = base.translate(messageNameKey);
                    }
                    String messageName = null;
                    if (JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                        jp.nextToken();
                    }
                    if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                        throw new JsonParseException("The attribute name is expected", jp.getCurrentLocation());
                    }
                    TokenBuffer tb = new TokenBuffer(null, false);
                    tb.writeStartObject();
                    String keyName = jp.getText();
                    if (messageNameKey.equals(keyName)) {
                        if (!JsonToken.VALUE_STRING.equals((Object)jp.nextToken())) {
                            throw new JsonParseException("The text attribute '" + messageNameKey + "' is expected at the begin of json", jp.getCurrentLocation());
                        }
                        messageName = jp.getText();
                    } else {
                        JsonToken t = jp.getCurrentToken();
                        while (t == JsonToken.FIELD_NAME) {
                            String name = jp.getCurrentName();
                            jp.nextToken();
                            if (messageNameKey.equals(name)) {
                                messageName = jp.getText();
                                jp.nextToken();
                                break;
                            }
                            tb.writeFieldName(name);
                            tb.copyCurrentStructure(jp);
                            t = jp.nextToken();
                        }
                    }
                    jp = JsonParserSequence.createFlattened((JsonParser)tb.asParser(jp), (JsonParser)jp);
                    jp.nextToken();
                    if (messageName != null) {
                        ProtocolUnknownMessage msg;
                        if ("ProtocolUnknownMessage".equals(messageName)) {
                            msg = FactoryHolder.unknownMessageDeserializer.deserialize(jp, ctxt);
                        } else {
                            Class c = FactoryHolder.protocolFactory.getMessageClass(messageName);
                            msg = (Message)jp.getCodec().readValue(jp, c);
                        }
                        return (RoutingServerMessage)msg;
                    }
                    throw new JsonParseException("The attribute '" + messageNameKey + "' is expected (it should be the first JSON attribute)", jp.getCurrentLocation());
                }
            });
        }
    }

    public static void setup(Module.SetupContext context) {
        context.setMixInAnnotations(RequestFindTarget.class, RequestFindTargetMixIn.class);
        context.setMixInAnnotations(RequestCancelExecution.class, RequestCancelExecutionMixIn.class);
        context.setMixInAnnotations(RequestQueryExecution.class, RequestQueryExecutionMixIn.class);
        context.setMixInAnnotations(EventError.class, EventErrorMixIn.class);
        context.setMixInAnnotations(EventInfo.class, EventInfoMixIn.class);
        context.setMixInAnnotations(EventOpenOK.class, EventOpenOKMixIn.class);
        context.setMixInAnnotations(EventExecutionAck.class, EventExecutionAckMixIn.class);
        context.setMixInAnnotations(EventExecutionError.class, EventExecutionErrorMixIn.class);
    }

    public static boolean isAvailable() {
        return PSDKCommonModule.isProtocolAvailable("Routing", "RoutingServer");
    }

    @Override
    public Class<?> getMarkerClass() {
        return RoutingServerMessage.class;
    }

    @Override
    public Class<? extends Message> getMessageClass(String name) {
        return FactoryHolder.protocolFactory.getMessageClass(name);
    }

    @Override
    public ProtocolUnknownMessage createUnknownMessage(int messageId) {
        return FactoryHolder.protocolFactory.unknownProtocolMessage(messageId);
    }

    private static class FactoryHolder
    extends RoutingServerInternalProtocolFactory {
        private static final FactoryHolder protocolFactory = new FactoryHolder();
        private static final ProtocolUnknownMessageDeserializer unknownMessageDeserializer = new ProtocolUnknownMessageDeserializer((AbstractProtocolFactory)protocolFactory);

        private FactoryHolder() {
        }

        public ProtocolUnknownMessage unknownProtocolMessage(int messageId) {
            return (ProtocolUnknownMessage)super.unknownProtocolMessage(messageId);
        }
    }
}

