/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2.runtime;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.json.jackson2.runtime.DefaultPropertyNamingStrategy;
import java.io.IOException;

public class ProtocolUnknownMessageDeserializer
extends JsonDeserializer<ProtocolUnknownMessage> {
    private final AbstractProtocolFactory protocolFactory;

    public ProtocolUnknownMessageDeserializer(AbstractProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public ProtocolUnknownMessage deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String referenceAttributeKey0;
        if (JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
            jp.nextToken();
        }
        String messageIdKey = "messageId";
        String messageNameKey = "messageName";
        String referenceAttributeKey = referenceAttributeKey0 = this.protocolFactory.getReferenceAttributeName();
        PropertyNamingStrategy strategy = ((ObjectMapper)jp.getCodec()).getDeserializationConfig().getPropertyNamingStrategy();
        if (strategy instanceof PropertyNamingStrategy.PropertyNamingStrategyBase) {
            PropertyNamingStrategy.PropertyNamingStrategyBase base = (PropertyNamingStrategy.PropertyNamingStrategyBase)strategy;
            messageIdKey = base.translate(messageIdKey);
            messageNameKey = base.translate(messageNameKey);
            referenceAttributeKey = referenceAttributeKey != null ? base.translate(referenceAttributeKey) : null;
        } else if (referenceAttributeKey != null) {
            referenceAttributeKey = DefaultPropertyNamingStrategy.translate(referenceAttributeKey);
        }
        boolean definedMessageName = false;
        boolean definedMessageId = false;
        int messageId = -1;
        boolean definedReferenceId = referenceAttributeKey == null;
        int referenceId = -1;
        if (JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
            jp.nextToken();
        }
        TokenBuffer tb = new TokenBuffer(null, false);
        tb.writeStartObject();
        JsonToken t = jp.getCurrentToken();
        while (t == JsonToken.FIELD_NAME) {
            String name = jp.getCurrentName();
            jp.nextToken();
            if (messageIdKey.equals(name)) {
                if (!JsonToken.VALUE_NUMBER_INT.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException("Integer attribute 'messageId' is expected but found " + jp.getCurrentToken(), jp.getCurrentLocation());
                }
                messageId = jp.getIntValue();
                definedMessageId = true;
                if (definedMessageName && definedReferenceId) {
                    break;
                }
            } else if (messageNameKey.equals(name)) {
                if (!JsonToken.VALUE_STRING.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException("Text attribute 'messageName' is expected but found " + jp.getCurrentToken(), jp.getCurrentLocation());
                }
                String messageName = jp.getText();
                if (!"ProtocolUnknownMessage".equals(messageName)) {
                    throw new JsonParseException("Expected message name is 'ProtocolUnknownMessage' but found: " + messageName, jp.getCurrentLocation());
                }
                definedMessageName = true;
                if (definedMessageId && definedReferenceId) {
                    break;
                }
            } else if (name.equals(referenceAttributeKey)) {
                if (!JsonToken.VALUE_NUMBER_INT.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException("Integer reference attribute '" + referenceAttributeKey + "' is expected but found " + jp.getCurrentToken(), jp.getCurrentLocation());
                }
                referenceId = jp.getIntValue();
                definedReferenceId = true;
                if (definedMessageName && definedMessageId) {
                    break;
                }
            } else {
                tb.writeFieldName(name);
                tb.copyCurrentStructure(jp);
            }
            t = jp.nextToken();
        }
        jp = JsonParserSequence.createFlattened((JsonParser)tb.asParser(jp), (JsonParser)jp);
        jp.nextToken();
        if (definedMessageId) {
            ProtocolUnknownMessage msg = (ProtocolUnknownMessage)this.protocolFactory.unknownProtocolMessage(messageId);
            if (msg == null) {
                throw new JsonParseException("Protocol doesn't support unknown message", null);
            }
            if (referenceAttributeKey != null && definedReferenceId) {
                ((DataSupport)msg).attributes().put(referenceAttributeKey0, referenceId);
            }
            ((ObjectMapper)jp.getCodec()).readerForUpdating((Object)msg).readValue(jp);
            return msg;
        }
        throw new JsonParseException("The attribute '" + messageIdKey + "' is expected (it should be the first JSON attribute)", jp.getCurrentLocation());
    }
}

