@echo off

:: User variables. Adapt to your environment
set HOST=[hostname]
set PORT=7500
set VERBOSE=false

set CLASSPATH=./gdpr-ucsdata-9.0.0.jar
set CLASSPATH=%CLASSPATH%;./lib/commons.jar
set CLASSPATH=%CLASSPATH%;./lib/connection.jar
set CLASSPATH=%CLASSPATH%;./lib/contactsprotocol.jar
set CLASSPATH=%CLASSPATH%;./lib/guava.jar
set CLASSPATH=%CLASSPATH%;./lib/jackson-annotations.jar
set CLASSPATH=%CLASSPATH%;./lib/jackson-core.jar
set CLASSPATH=%CLASSPATH%;./lib/jackson-databind.jar
set CLASSPATH=%CLASSPATH%;./lib/jackson2-module.jar
set CLASSPATH=%CLASSPATH%;./lib/kvlistbinding.jar
set CLASSPATH=%CLASSPATH%;./lib/kvlists.jar
set CLASSPATH=%CLASSPATH%;./lib/netty.jar
set CLASSPATH=%CLASSPATH%;./lib/openmediaprotocol.jar
set CLASSPATH=%CLASSPATH%;./lib/protocol.jar
set CLASSPATH=%CLASSPATH%;./lib/system.jar

if [%1]==[] GOTO :usage

java -classpath %CLASSPATH% com.genesyslab.eservices.gdpr.ContactDeleter %*
GOTO :end

:usage
echo Usage:
echo     To simulate contact deletion, specify a list of contacts Id in between double quotes and separated with a comma.
echo     Example:
echo         %0 "contactId1,contactId2"
echo.
echo     or use a json string to search by any other attributes, like email address.
echo     Example:
echo         %0 "{\"TenantId\":101,\"EmailAddress\':\"foo@bar.com\"}"
echo.
echo     To perform contact deletion, add -confirm argument
echo     Example:
echo         %0 contactId -confirm
echo         %0 "{\"TenantId\":101,\"EmailAddress\':\"foo@bar.com\"}" -confirm
echo.
:end
