#!/bin/bash

#User variables. Adapt to your environment
export HOST=[hostname]
export PORT=7500
export VERBOSE=false

# Set env variables. Do not change them
CLASSPATH="./gdpr-ucsdata-9.0.0.jar"
CLASSPATH="${CLASSPATH}:./lib/commons.jar"
CLASSPATH="${CLASSPATH}:./lib/connection.jar"
CLASSPATH="${CLASSPATH}:./lib/contactsprotocol.jar"
CLASSPATH="${CLASSPATH}:./lib/guava.jar"
CLASSPATH="${CLASSPATH}:./lib/jackson-annotations.jar"
CLASSPATH="${CLASSPATH}:./lib/jackson-core.jar"
CLASSPATH="${CLASSPATH}:./lib/jackson-databind.jar"
CLASSPATH="${CLASSPATH}:./lib/jackson2-module.jar"
CLASSPATH="${CLASSPATH}:./lib/kvlistbinding.jar"
CLASSPATH="${CLASSPATH}:./lib/kvlists.jar"
CLASSPATH="${CLASSPATH}:./lib/netty.jar"
CLASSPATH="${CLASSPATH}:./lib/openmediaprotocol.jar"
CLASSPATH="${CLASSPATH}:./lib/protocol.jar"
CLASSPATH="${CLASSPATH}:./lib/system.jar"

if [ -z "$1" ]; then
  me=`basename "$0"`
  echo "Usage:"
  echo $'\t' "To simulate contacts deletion, specify a list of contacts Id separated with a comma"
  echo $'\t\t' Example:
  echo $'\t\t' "./${me} contactId1,contactId2"
  echo
  echo $'\t' "or use a json string to search by any other attributes, like email address."
  echo $'\t\t' Example:
  echo $'\t\t' "./${me} \"{\\\"TenantId\\\":101,\\\"EmailAddress\\\":\\\"foo@bar.com\\\"}\""
  echo
  echo $'\t' "To perform contact deletion, add -confirm argument"
  echo $'\t\t' "./${me} contactId -confirm"
  echo $'\t\t' "./${me} \"{\\\"TenantId\\\":101,\\\"EmailAddress\\\":\\\"foo@bar.com\\\"}\" -confirm"
  echo
  exit 0
fi

java -classpath "${CLASSPATH}" com.genesyslab.eservices.gdpr.ContactDeleter "$@"
