package com.genesyslab.gax.sampledb.main;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.genesyslab.gax.api.communication.ObjectInformation;
import com.genesyslab.gax.common.communication.Information;
import com.genesyslab.gax.common.communication.InformationHandler;
import com.genesyslab.gax.sampledb.dao.SampleTestDao;
import com.genesyslab.gax.sampledb.entities.SampleTest;

/**
 * service provider, listening for the request from other plugins.
 *
 */
@Service
public class SampleDBInformationProvider implements InformationHandler {

	@Autowired
	private SampleTestDao sampleTestDao;
	
	@Override
	/**
	 * listening for RequestMethod.readByTenantId, return the count of the sampleTest of the tenant.
	 * (non-Javadoc)
	 * @see com.genesyslab.gax.common.communication.InformationHandler#Process(com.genesyslab.gax.common.communication.Information)
	 */
	public Information Process(Information input) {
		ObjectInformation result = null;

		/*
		 * only the RequestMethod.readByTenantId get processed.
		 */
		if (input.getHeader().get("RequestMethod").equals("readByTenantId")) {
			if (input instanceof ObjectInformation) {
				List<SampleTest> ret = new ArrayList<SampleTest>();
				Integer[] ids =  (Integer[])((ObjectInformation) input).getBody();
				for(Integer id: ids) {
					List<SampleTest> st = sampleTestDao.readByTenantId(id);
					ret.addAll(st);
				}
				result = new ObjectInformation(ret);
			}
		}
		return result;

	}
	

}
