package com.genesyslab.gax.sampledb.spring;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;

import com.genesyslab.gax.common.database.DataSourceManager;
import com.genesyslab.gax.common.database.DatabaseType;

@Configuration("sampleConfig")
public class ConfigDataSource {

	@Autowired
	private DataSourceManager dataSourceManager;

	/**
	 * 
	 * @return HibernateJpaVendorAdapter which exposes Hibernate's persistence provider
	 *  and EntityManager extension, and commons config setting
	 */
	@Bean
	public HibernateJpaVendorAdapter sampleJpaVendorAdapter() {
		HibernateJpaVendorAdapter jpaVendorAdapter = new org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter();
		jpaVendorAdapter.setShowSql(false);
		jpaVendorAdapter.setGenerateDdl(false);
		/*
		 * set database platform
		 */
		DatabaseType dbType = dataSourceManager.getDatabaseType("sample");
		if (dbType == DatabaseType.ORACLE) {
			jpaVendorAdapter.setDatabasePlatform(DataSourceManager.ORACLE_DIALECT);
		} else if (dbType == DatabaseType.MSSQL) {
			jpaVendorAdapter.setDatabasePlatform(DataSourceManager.MSSQL_DIALECT);
		} else if(dbType == DatabaseType.POSTGRE) {
			jpaVendorAdapter.setDatabasePlatform(DataSourceManager.POSTGRE_DIALECT);
		}

		return jpaVendorAdapter;
	}

	@Bean
	public DataSource sampleDataSource() {
		//should be the same as in database.DB_SCHEMA_VERSION
		return dataSourceManager.getDataSource("sample", "main");
	}
}
