package com.genesyslab.gax.sampledb.web;


import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import com.genesyslab.gax.common.ObjectNotFoundException;
import com.genesyslab.gax.sampledb.entities.SampleTest;
import com.genesyslab.gax.sampledb.service.SampleService;

/**
 * 
 * spring MVC based controller, web layer that translates
 * HTTP requests to service layer APIs.
 */
@Controller
@RequestMapping(value="/sampledb")
public class SampleDBController {
	@Autowired
	private SampleService sampleService ;
	
	final Logger logger = LoggerFactory.getLogger(this.getClass());

	
	/**
	 * <b>Retrieves the list of all Sampletest.</b> (
	 * An example for URL would be:
	 * <em>http://localhost:8080/gax/api/sampledb</em> <br/>
	 * <em>Used only with the HTTP method GET.</em>
	 * @throws IOException
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<SampleTest> readAll(HttpServletResponse response) {
		List<SampleTest> parameters = sampleService.findAll();
		return parameters;
	}
	
	/**
	 * <b>Retrieves the a Sampletest by id.</b> (
	 * An example for URL would be:
	 * <em>http://localhost:8080/gax/api/sampledb/id</em> <br/>
	 * <em>Used only with the HTTP method GET.</em>
	 * @throws IOException
	 */
	@RequestMapping(value = "{id}", method = RequestMethod.GET)
	public @ResponseBody SampleTest getById(@PathVariable Long id) {
		SampleTest ret = sampleService.findById(id);
		return ret;
	}
	
	/**
	 * <b>Create a Sampletest.</b> (
	 * An example for URL would be:
	 * <em>http://localhost:8080/gax/api/sampledb/</em> <br/>
	 * <em>Used only with the HTTP method POST.</em>
	 * @throws IOException
	 */
	@RequestMapping(method = RequestMethod.POST)
	public void create(@RequestBody SampleTest input, HttpServletResponse response)
			throws Exception {
		//input.setId(null);
		sampleService.create(input);		
	}
	
	/**
	 * <b>Update a Sampletest by id.</b> (
	 * An example for URL would be:
	 * <em>http://localhost:8080/gax/api/sampledb/id</em> <br/>
	 * <em>Used only with the HTTP method PUT.</em>
	 * @throws IOException
	 */
	@RequestMapping(value = "{id}", method = RequestMethod.PUT)
	public @ResponseBody SampleTest updateById(@PathVariable Long id, @RequestBody SampleTest input) {
		SampleTest ret = sampleService.findById(id);
		if(ret == null) {
			throw new ObjectNotFoundException();
		}
		ret.setDescription(input.getDescription());
		ret.setName(input.getName());
		ret.setTenantId(input.getTenantId());
		ret = sampleService.update(ret);
		return ret;
	}

}

