package com.genesyslab.gax.sampledb.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import com.genesyslab.gax.api.persistence.PersistenceService;
import com.genesyslab.gax.api.persistence.PersistentRecord;
import com.genesyslab.gax.common.ObjectNotFoundException;
import com.genesyslab.gax.sampledb.entities.SampleTest;


/**
 * 
 * spring MVC based controller, web layer that translates
 * HTTP requests to service layer APIs.
 */
@Controller
@RequestMapping(value="/sampledb")
public class SamplePersistenceController {
	
	private static final String categoryId = "samplepersistence";
	
	@Autowired
	private PersistenceService persistence;
	
	/**
	 * An example for URL would be:
	 * <em>http://localhost:8080/gax/api/sampledb/persistence</em> <br/>
	 * <em>Used only with the HTTP method POST.</em>
	 * 
	 * @param input JSON format string
	 * @param response
	 * @throws Exception
	 */
	@RequestMapping(value="persistence", method = RequestMethod.POST)
	public void create(@RequestBody String input, HttpServletResponse response)
			throws Exception {
		PersistentRecord record = new PersistentRecord();
		record.setCategory(categoryId);
		record.setParentId(null);
		record.setContent(input);
		persistence.createRecord(record);
	}
	
	/**
	 * An example for URL would be:
	 * <em>http://localhost:8080/gax/api/sampledb/persistence</em> <br/>
	 * <em>Used only with the HTTP method POST.</em>
	 * 
	 * @param response
	 * @return
	 * @throws JSONException
	 * @throws JsonParseException
	 * @throws JsonMappingException
	 * @throws IOException
	 */
	@RequestMapping(value="persistence", method = RequestMethod.GET)
	public @ResponseBody List<SampleTest> test(HttpServletResponse response) throws JSONException, JsonParseException, JsonMappingException, IOException {
		ObjectMapper mapper = new ObjectMapper();
		List<PersistentRecord> prs = persistence.readRootCategory(categoryId);
		List<SampleTest> ret = new ArrayList<SampleTest>();
		for(PersistentRecord pr: prs) {
			SampleTest st = mapper.readValue(pr.getContent(), SampleTest.class);
			st.setId(pr.getId());
			ret.add(st);
		}
		return ret;
	}
	
	/**
	 * <b>Retrieves a Sampletest by id.</b> (
	 * An example for URL would be:
	 * <em>http://localhost:8080/gax/api/sampledb/persistence/id</em> <br/>
	 * <em>Used only with the HTTP method GET.</em>
	 * @throws JSONException 
	 * @throws JsonMappingException 
	 * @throws JsonParseException 
	 * @throws IOException
	 */
	@RequestMapping(value = "persistence/{id}", method = RequestMethod.GET)
	public @ResponseBody SampleTest getById(@PathVariable Long id) throws JSONException, JsonParseException, JsonMappingException, IOException {
		PersistentRecord pr = persistence.readRecord(id);
		if(pr!=null) {
			ObjectMapper mapper = new ObjectMapper();
			SampleTest st = mapper.readValue(pr.getContent(), SampleTest.class);
			st.setId(pr.getId());
			return st;
		}		
		return null;
	}
	
	/**
	 * <b>Update a Sampletest by id.</b> (
	 * An example for URL would be:
	 * <em>http://localhost:8080/gax/api/sampledb/persistence/id</em> <br/>
	 * <em>Used only with the HTTP method PUT.</em>
	 * @throws JsonMappingException 
	 * @throws JsonParseException 
	 * @throws IOException
	 */
	@RequestMapping(value = "persistence/{id}", method = RequestMethod.PUT)
	public @ResponseBody SampleTest updateById(@PathVariable Long id, @RequestBody String input) throws JsonParseException, JsonMappingException, IOException {
		PersistentRecord pr = persistence.readRecord(id);
		if(pr == null) {
			throw new ObjectNotFoundException();
		}
		pr.setContent(input);
		persistence.updateRecord(pr);
		ObjectMapper mapper = new ObjectMapper();
		SampleTest st = mapper.readValue(pr.getContent(), SampleTest.class);
		st.setId(pr.getId());
		return st;
	}
}
