define([
    "underscore",
    "gax",
    "./cfgTypes",
    "./model",
    "../nls/lk"
], function (_, gax, cfgTypes, Model, lk) {
    "use strict";
    return gax.widgets.DetailPanel.extend({
        options: _.defaults({
            lk: lk,
        }, gax.widgets.DetailPanel.prototype.options),
        initialize: function () {
            gax.widgets.DetailPanel.prototype.initialize.call(this);
        },
        render: function () {
            var that = this,
                content = [],
                model;

            if (this.options.itemId) {
                model = Model.prototype.readOne({ id: this.options.itemId });
            } else {
                model = Model.prototype.create();
            }

            this.options.model = model;

            this.editor = new gax.widgets.Editor({
                model: model,
                lk: lk,
                onPersist: this.options.onPersist,
                content: [{
                    type: "ConfigObject",
                    archetype: "CfgTenant",
                    name: "tenant",
                    label: lk.titles.TENANT,
                    mandatory: true,
                    binding: {
                        get: function (viewModel) {
                            return {
                                id: viewModel.get("tenantId"),
                                name: viewModel.get("tenantName"),
                                type: "CfgTenant"
                            };
                        },
                        set: function (viewModel) {
                            var tenant = that.editor.items.tenant.getValue();
                            viewModel.set("tenantId", tenant.id);
                            viewModel.set("tenantName", tenant.name);
                        }
                    }
                }, {
                    type: "TextField",
                    name: "sample_name",
                    label: lk.titles.SAMPLE_NAME,
                    id: "name",
                    mandatory: false,
                    binding: {
                        prop: "name"
                    }
                },  {
                    type: "TextField",
                    name: "sample_description",
                    label: lk.titles.SAMPLE_DESCRIPTION,
                    id: "description",
                    mandatory: false,
                   
                    binding: {
                        prop: "description"
                    }
                }]
            });

            that.editor._beforeSave = function (viewModel) {
//                delete viewModel.object.name;
                if (that.options.itemId) {
                    viewModel.set("tenantId", that._prov.tenantId);
                    viewModel.set("tenantName", that._prov.tenantName);
                }
            };

            content.push(that.editor);

            gax.widgets.DetailPanel.prototype.render.call(this);

            this.append(content);

            if (this.options.itemId) {
                that.editor.items.tenant.setEnabled(false);
                model.done(function (model) {
                    that._prov = model.get();
                    
                    that._checkButtons();

                });
            }

            return this;
        },
        _checkButtons: function () {
            // control the delete button
            if (!this.future) {
                this.headerButtonBar.items["delete"].setEnabled(false);
            }
        }
    });
});
