define([
    "gax",
    "./list",
    "./details",
    "../nls/lk"
], function (gax, List, Details, lk) {
    "use strict";
    return {
        name: "sampledbs",
        extensions: [{
            id: "nav:category",
            extension: function () {
                return {
                    name: "sampledb",
                    title: lk.titles.ADVANCED_SAMPLE,
                    icon: "parameters",
                    category: "operations"
                };
            }
        }, {
            id: "nav:item",
            extension: function () {
                return {
                    category: "sampledb",
                    target: "list:sampledb.list",
                    title: lk.titles.SAMPLE_DB,
                    icon: "parameters",
                    privilege: "READ_PLUGINS"
                };
            }
        }, {
            id: "list:sampledb.list",
            panel: List
        }, {
            id: "details:sampledb.detail",
            panel: Details
        }]
    };
});
