/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.samples.interceptor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AlarmFileManager {
    private BufferedOutputStream logBuffer;
    private static AlarmFileManager instance;
    private static SimpleDateFormat dateFormat;

    public static AlarmFileManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new AlarmFileManager();
        return instance;
    }

    public synchronized void open(String rootPath) {
        if (this.logBuffer == null) {
            Date now = new Date();
            StringBuffer fileName = new StringBuffer(rootPath);
            fileName.append(File.separator);
            fileName.append("alarm_");
            fileName.append(dateFormat.format(now));
            fileName.append(".log");
            File file = new File(fileName.toString());
            try {
                FileOutputStream fos = new FileOutputStream(file);
                this.logBuffer = new BufferedOutputStream(fos);
            }
            catch (Exception e) {
                System.out.println("file opening failed:" + e);
            }
        } else {
            System.out.println("There is already an opened alarm file");
        }
    }

    public synchronized void append(String message) {
        if (this.logBuffer != null) {
            Date now = new Date();
            String line = now.toString() + ":" + message + "\n";
            try {
                this.logBuffer.write(line.getBytes());
                this.logBuffer.flush();
            }
            catch (Exception e) {
                System.out.println("write in file failed:" + e);
            }
        } else {
            System.out.println("There isn't any opened alarm file");
        }
    }

    public synchronized void close() {
        if (this.logBuffer != null) {
            try {
                this.logBuffer.close();
                this.logBuffer = null;
            }
            catch (Exception e) {
                System.out.println("file closure failed:" + e);
            }
        }
    }

    static {
        dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
    }
}

