<%@ page language="java" buffer="none" contentType="text/html; charset=utf-8" %>
<%@ page import="java.text.DateFormat" %>
<%@ page import="java.util.Date" %>
<%@ page import="java.util.Locale" %>
<%@ page import="com.genesyslab.ail.AilFactory" %>
<%@ page import="com.genesyslab.ail.AilLoader" %>
<%@ page import="com.genesyslab.ail.InteractionOpenMedia" %>
<%@ include file="../../extension/common/util.jsp" %>
<%
    AilFactory factory = AilLoader.getAilFactory();
    String idInteraction = request.getParameter("idInteraction");
    InteractionOpenMedia fax = (InteractionOpenMedia) factory.getInteraction(idInteraction);

    String strSubject = fax.getSubject();

    Date date = fax.getDateCreated();
    String strDate = "";
    if (date != null) {
        Locale locale = (Locale)session.getAttribute("regionalSettingsLocale");
        DateFormat df = DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG, locale);
        strDate = df.format(date);
    }

    String contentBinaryMimeType = fax.getContentBinaryMimeType();
%>
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <link rel="stylesheet" type="text/css" href="extension/common/extensionStyle.css"/>
    <script language="javascript">
      window.parent.includeGDFunctionalities(window);

      function custom_load() {
        activateGDFunctionalities();
      }

      function custom_unload() {
        unactivateGDFunctionalities();
      }
    </script>
  </head>
  <body class="extScrollBar extBackgroundRoundedPanel" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onload="custom_load()" onunload="custom_unload()">
    <table width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
      <tr valign="top">
        <td class="extNotEditablePanelDarkShadow" width="1" align="left" rowspan="3"><img src="extension/fax/empty.gif"></td>
        <td class="extNotEditablePanelDarkShadow" height="1"><img src="extension/fax/empty.gif"></td>
        <td class="extNotEditablePanelLightShadow" width="1" align="right" rowspan="3"><img src="extension/fax/empty.gif"></td>
      </tr>
      <tr valign="top">
        <td class="extNotEditablePanelBackground" width="100%" align="left">
          <table class="fontName" style="width:100%;height:100%" border="0" cellpadding="0" cellspacing="0" vspace="0" hspace="0">
            <tr height="5px"><td rowspan="12" width="5px"></td><td></td><td rowspan="12" width="5px"></td></tr>
            <tr height="18px">
              <td class="extNotEditablePanelText">FAX</td>
            </tr>
            <tr height="18px"><td class="extNotEditablePanelText">Subject:&nbsp;<b><%= stringToHtml(strSubject) %></b></td></tr>
            <tr height="18px"><td class="extNotEditablePanelText">Date:&nbsp;<b><%= stringToHtml(strDate) %></b></td></tr>
            <tr height="10px"><td></td></tr>
            <tr>
              <td class="extNotEditablePanelText" height="100%">
                <table width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
                  <tr valign="top">
                    <td class="extNotEditablePanelDarkShadow" width="1" align="left" rowspan="3"><img src="extension/fax/empty.gif"></td>
                    <td class="extNotEditablePanelDarkShadow" height="1"><img src="extension/fax/empty.gif"></td>
                    <td class="extNotEditablePanelLightShadow" width="1" align="right" rowspan="3"><img src="extension/fax/empty.gif"></td>
                  </tr>
                  <tr valign="top" style="width:100%;height:100%">
                    <td class="extNotEditableFaxPanelBackground" align="center" height="100%">
<%
    if (contentBinaryMimeType != null) {
    if ( (contentBinaryMimeType.endsWith("jpeg")) || (contentBinaryMimeType.endsWith("png")) || (contentBinaryMimeType.endsWith("gif")) ) {
%>
                      <img style="height:100%" src="extension/fax/fax-content.jsp?idInteraction=<%=idInteraction%>" border="0">
<%
    } else {
%>
                      <iframe style="width:100%;height:100%" src="extension/fax/fax-content.jsp?idInteraction=<%=idInteraction%>&path=../../" frameborder="0" scrolling="yes"></iframe>
<%
    }
    }
%>
                    </td>
                  </tr>
                  <tr valign="bottom"><td class="extNotEditablePanelLightShadow" height="1"><img src="extension/fax/empty.gif"></td></tr>
                </table>
              </td>
            </tr>
            <tr ><td height="5px"><img src="extension/fax/empty.gif"  height="5px"></td></tr>
          </table>
        </td>
      </tr>
      <tr valign="bottom"><td class="extNotEditablePanelLightShadow" height="1"><img src="extension/fax/empty.gif"></td></tr>
    </table>
    <script language="javascript">
      document.oncontextmenu = function(){return false;}
    </script>
  </body>
</html>
