<%@ page language="java" buffer="none" %>
<%@ page import="java.util.Collection" %>
<%@ page import="java.util.Map" %>
<%@ page import="java.util.Vector" %>
<%@ page import="com.genesyslab.ail.AilFactory" %>
<%@ page import="com.genesyslab.ail.AilLoader" %>
<%@ page import="com.genesyslab.ail.Agent" %>
<%@ page import="com.genesyslab.ail.ApplicationInfo" %>
<%@ page import="com.genesyslab.ail.Contact" %>
<%@ page import="com.genesyslab.ail.ContactManager" %>
<%@ page import="com.genesyslab.ail.Interaction" %>
<%@ page import="com.genesyslab.ail.InteractionMailOut" %>
<%@ page import="com.genesyslab.ail.InteractionOpenMedia" %>
<%@ page import="com.genesyslab.ail.EmailAddress" %>
<%@ page import="com.genesyslab.ail.Place" %>
<%@ page import="com.genesyslab.ail.exception.RequestFailedException" %>
<html>
  <head>
   	<script language="javascript">
      window.parent.includeGDFunctionalities(window);

      function custom_load() {
        activateGDFunctionalities();
      }

      function custom_unload() {
        unactivateGDFunctionalities();
      }
    </script>
  </head>
  <body onload="custom_load()" onunload="custom_unload()">
<%
    AilFactory factory = AilLoader.getAilFactory();
    InteractionOpenMedia openMedia = (InteractionOpenMedia) factory.getInteraction(request.getParameter("idInteraction"));

    String emailDefaultQueueOption = null;
    String emailReplyPrefixOption = "";
    ApplicationInfo applicationInfo = factory.getApplicationInfo();
    if (applicationInfo != null) {
        Map section = (Map) applicationInfo.mOptions.get("multimedia");
        if (section != null) {
            emailDefaultQueueOption = (String) section.get("email-default-queue");
            emailReplyPrefixOption = (String) section.get("email-reply-prefix");
            if (emailReplyPrefixOption == null)
                emailReplyPrefixOption = "";
            else
                emailReplyPrefixOption += " ";
        }
    }


    if ( (emailDefaultQueueOption != null) && !(emailDefaultQueueOption.equals("")) ) {
        String userName = (String)request.getParameter("userName");
        if ( (userName != null) && !(userName.equals("")) ) {
            Agent agent = (Agent) factory.getPerson(userName);
            if (agent != null) {
                Place place = agent.getPlace();
                if (place != null) {
                    try {
                        InteractionMailOut emailOut = (InteractionMailOut) place.createInteraction(Interaction.Type.EMAILOUT_REPLY, openMedia);
                        emailOut.setNotepad(openMedia.getNotepad());
                        emailOut.setSubject(emailReplyPrefixOption + openMedia.getSubject());

                        String contactId = openMedia.getContactId();
                        if ( (contactId != null) && (contactId.length() > 0) ) {
                            ContactManager contactMgr = factory.getContactManager();
                            if (contactMgr != null) {
                                Vector contactAttributes = new Vector();
                                contactAttributes.addElement(contactMgr.getEmailAddressAttribute());
                                Contact contact = contactMgr.getContact(contactId, contactAttributes);
                                if (contact != null) {
                                    EmailAddress[] eMailOutToAddresses = factory.createEmailAddresses(contact.getPrimaryEmailAddress());
                                    if (eMailOutToAddresses != null)
                                        emailOut.setToAddresses(eMailOutToAddresses);
                                }
                            }
                        }

                        Collection agentAddresses = factory.getIncomingAddresses();
                        if ( (agentAddresses != null) && !(agentAddresses.isEmpty()) )
                            emailOut.setFromAddress((EmailAddress)(agentAddresses.iterator().next()));

                        emailOut.submit(emailDefaultQueueOption);

                        } catch(RequestFailedException requestFailedException) {
%>
    <script language="javascript">
      window.parent.displayInitialPanel();
    </script>
<%
                        }
                }
            }
        }
    }
%>
  </body>
</html>
