<%@ page language="java" buffer="none" %>
<%@ page import="java.util.Map" %>
<%@ page import="com.genesyslab.ail.AilFactory" %>
<%@ page import="com.genesyslab.ail.AilLoader" %>
<%@ page import="com.genesyslab.ail.Agent" %>
<%@ page import="com.genesyslab.ail.ApplicationInfo" %>
<%@ page import="com.genesyslab.ail.InteractionOpenMedia" %>
<%@ page import="com.genesyslab.ail.InteractionVoice" %>
<%@ page import="com.genesyslab.ail.MediaType" %>
<%@ page import="com.genesyslab.ail.Place" %>
<%@ page import="com.genesyslab.ail.exception.RequestFailedException" %>
<html>
  <head>
   	<script language="javascript">
      window.parent.includeGDFunctionalities(window);

      function custom_load() {
        activateGDFunctionalities();
      }

      function custom_unload() {                                                       
        unactivateGDFunctionalities();
      }
    </script>
  </head>
  <body onload="custom_load()" onunload="custom_unload()">
<%
    AilFactory factory = AilLoader.getAilFactory();
    InteractionOpenMedia openMedia = (InteractionOpenMedia) factory.getInteraction(request.getParameter("idInteraction"));

    String userName = (String)request.getParameter("userName");
    if ( (userName != null) && !(userName.equals("")) ) {
        Agent agent = (Agent) factory.getPerson(userName);
        if (agent != null) {
            Place place = agent.getPlace();
            if (place != null) {
                String emailReplyPrefixOption = "";
                ApplicationInfo applicationInfo = factory.getApplicationInfo();
                if (applicationInfo != null) {
                    Map section = (Map) applicationInfo.mOptions.get("multimedia");
                    if (section != null) {
                        emailReplyPrefixOption = (String) section.get("email-reply-prefix");
                        if (emailReplyPrefixOption == null)
                            emailReplyPrefixOption = "";
                        else
                            emailReplyPrefixOption += " ";
                    }
                }

                try {
                    InteractionVoice voiceOut = (InteractionVoice)place.createInteraction(MediaType.VOICE, openMedia, null);
                    voiceOut.setNotepad(openMedia.getNotepad());
                    voiceOut.setSubject(emailReplyPrefixOption + openMedia.getSubject());
                } catch(RequestFailedException requestFailedException) {
%>
    <script language="javascript">
      window.parent.displayInitialPanel();
    </script>
<%
                }
            }
        }
    }
%>
  </body>
</html>
