<%@ page language="java" buffer="none" contentType="text/html; charset=utf-8" %>
<%@ page import="java.text.DateFormat" %>
<%@ page import="java.util.Date" %>
<%@ page import="java.util.Locale" %>
<%@ page import="com.genesyslab.ail.AilFactory" %>
<%@ page import="com.genesyslab.ail.AilLoader" %>
<%@ page import="com.genesyslab.ail.InteractionOpenMedia" %>
<%@ include file="../../extension/common/util.jsp" %>
<%
    AilFactory factory = AilLoader.getAilFactory();
    InteractionOpenMedia sms = (InteractionOpenMedia) factory.getInteraction(request.getParameter("idInteraction"));

    String strSubject = sms.getSubject();
    String strMessage = sms.getText();

    Date date = sms.getDateCreated();
    String strDate = "";
    if (date != null) {
        Locale locale = (Locale)session.getAttribute("regionalSettingsLocale");
        DateFormat df = DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG, locale);
        strDate = df.format(date);
    }

%>
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="imagetoolbar" content="no">
    <link rel="stylesheet" type="text/css" href="extension/common/extensionStyle.css"/>
	<script language="javascript" src="extension/sms-out/htmlcontrol.js"></script>
    <script language="javascript">
      window.parent.includeGDFunctionalities(window);
 
      var extensionContext = window.parent.getExtensionContext();

      function custom_load() {
        var value = extensionContext["Interaction.Subject"];
        if (value != null) {
          document.getElementById("subjectField").value = value;
        } else {
          extensionContext["Interaction.Subject"] = "<%= stringToJavaScript(strSubject) %>";
        }
        value = extensionContext["Interaction.Text"];
        if (value != null) {
          document.getElementById("textField").value = value;
        } else {
          extensionContext["Interaction.Text"] = "<%= stringToJavaScript(strMessage) %>";
        }
        updateCounters();
        
	    activateGDFunctionalities();
        addControl(subjectControl);
        addControl(textControl);
        focusOnControl(textControl);
      }

      function custom_unload() {
        unactivateGDFunctionalities();
      }

      function nothing() {
      }

      function updateCounters() {
        var smsText = document.getElementById("textField").value;
        var nbChar = smsText.length;
        document.all["nbChar"].innerHTML = nbChar;
        var nbSms = ( ( nbChar - (nbChar % 160) ) / 160 ) + 1;
        document.all["nbSMS"].innerHTML = nbSms;
      }

      var caretPos = null;
      function storeCaretPos() {
        if (document.selection) {
            caretPos = document.selection.createRange().duplicate();
        }
      }

      function appendSRLTextInSmsOut(information) {
        insertAtCaret(document.getElementById("textField"), information, caretPos);
        storeCaretPos();
      }

      function insertAtCaret(obj, text, range) {
        var start = null;
        if ( (document.selection) && (range != null) ) {
          if (text == "")
            return true;

          var orig = obj.value.replace(/\r\n/g, "\n");
          if (range.parentElement() != obj)
            return false;

          range.text = text;
          range.select();

          return;
        } else if (obj.selectionStart != null) {
          start = obj.selectionStart;
          var end = obj.selectionEnd;
          obj.value = obj.value.substr(0, start)
                    + text
                    + obj.value.substr(end, obj.value.length);
        }
        if (start != null) 
          setCaretTo(obj, start + text.length);
        else {
          obj.value = text + obj.value;
          obj.focus();
          setCaretTo(obj,text.length);
        }
      }

      function setCaretTo(obj, pos) {
        if (obj.createTextRange) {
          var range = obj.createTextRange();
          range.move('character', pos);
          range.select(); 
        } else if(obj.selectionStart) {
          obj.focus();
          obj.setSelectionRange(pos, pos);
        }
      }
    </script>
  </head>
  <body class="extBackgroundPanel" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onload="custom_load()" onunload="custom_unload()">
      <table class="extFontName" width="100%" height="100%" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td>
            <table width="100%" border="0" cellspacing="0" cellpadding="0">
              <tr><td colspan="3"><img src="extension/sms-out/empty.gif" height="30"></td></tr>
              <tr width="100%">
                <td class="extLabelText" nowrap>Subject :</td>
                <td><img src="extension/sms-out/empty.gif" width="5"></td>
                <td width="100%" nowrap><input class="extEditableTextEnable" style="WIDTH:100%" type="text" id="subjectField" onchange="extensionContext['Interaction.Subject'] = this.value" value="<%= stringToHtml(strSubject,false)%>"></td>
              </tr>
              <tr width="100%">
                <td class="extLabelText" nowrap>Date :</td>
                <td><td width="100%" nowrap><input readonly="true" class="extEditableTextDisable" style="WIDTH:100%" type="text" name="dateField" value="<%= stringToHtml(strDate,false)%>"></td></td>
                <td><img src="extension/sms-out/empty.gif" width="5"></td>
              </tr>
              <tr><td colspan="3"><img src="extension/sms-out/empty.gif" height="5"></td></tr>
            </table>
          </td>
        </tr>
        <tr><td><img src="extension/sms-out/empty.gif" height="5"></td></tr>
        <tr align="right"><td class="extLabelText"><span id="nbChar">0</span>&nbsp;=&nbsp;<span id="nbSMS">1</span>&nbsp;SMS&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td></tr>
        <tr  height="100%">
          <td>
            <textarea class="extEditableTextEnable" id="textField" onclick="storeCaretPos()" onKeyDown="storeCaretPos();updateCounters()" onKeyUp="storeCaretPos();updateCounters()" onchange="extensionContext['Interaction.Text'] = this.value" style="height:100%;width:100%"><%= stringToHtml(strMessage)%></textarea>
          </td>
        </tr>
      </table>
    <script language="javascript">
      var subjectControl = createHTMLInputControl("subjectField");
      var textControl = createHTMLInputControl("textField");
      
      document.oncontextmenu = function(){return false;}
    </script>
  </body>
</html>