$.noConflict();

jQuery(document).ready(function($) { 

	var maxItems;

	var count = 0;

	var currentURL = window.location.href;

	var currentPage = window.location.pathname.split('/').pop();

	

	//First time through, get the data in the .page div and create an array

	var tabData = $(".page").html();

	

	if(tabData !== undefined) {

		var tabList = tabData.split("|-|");

		var getPage = function(pageNum) {

					

			//If the page is linking to a specific section heading (i.e. Documentation/Page#sectionheading) that is inside multistep, 

			//open the multistep control to the step that contains the section heading

			if (currentURL.indexOf("#") >= 0)

			{

				var tabHeader = currentURL.split("#").pop();

				if (tabHeader) {

					var searchResults = searchStringInArray (tabHeader, tabList);

					if (searchResults > -1) {

						pageNum = count = searchResults;

					}

				}

			}

			

			$(".page").html(tabList[pageNum]);

			maxItems = tabList.length;



			if (count == 0) {

				$('.vertical-tab-widget .next').removeClass('disabled');

				$('.vertical-tab-widget .previous').addClass('disabled');

			} else if (count == maxItems-1) {

				$('.vertical-tab-widget .previous').removeClass('disabled');

				$('.vertical-tab-widget .next').addClass('disabled');

			} else {

				$('.vertical-tab-widget .next').removeClass('disabled');

				$('.vertical-tab-widget .previous').removeClass('disabled');

			}

			$('.vertical-tab-widget .select-page').val(count);



		};

		getPage(0);

		$(document).on('click', '.vertical-tab-widget .previous', function(e) {

			if (count == 0) {

				return;

			} else {

				count--;

			}		

			getPage(count);	

			return false;			

		});	

		$(document).on('click', '.vertical-tab-widget .next', function(e) {

			if (count == maxItems-1) {

				return;

			} else {

				count++;

			}

			getPage(count);		

			return false;

		});

		$(document).on('change', '.vertical-tab-widget .select-page', function() {

			count = $(this).val();

			getPage(count);

		});

		

		//User clicked a link to content within the multistep extension. Find the tab 

		//where the link is located and display it to the user

		$(document).on('click', '.vertical-tab-widget a[href^="#"], a[href*="' + currentPage + '#"]', function() {

			var tabHeader = $(this).attr("href").split("#").pop();

			if (tabHeader) var pageCount = searchStringInArray (tabHeader, tabList);



			if (pageCount > -1) {

				count = pageCount;

				getPage(count);

			}

		});

	}

});



//SOURCE: http://stackoverflow.com/questions/5424488/javascript-search-for-a-string-inside-an-array-of-strings

function searchStringInArray (str, strArray) {

	str = 'id="' + str + '"';

    for (var j=0; j<strArray.length; j++) {

        if (strArray[j].match(str)) return j;

    }

    return -1;

}