'use strict';

angular.module('cs.query')
.controller('DeleteController', ['$scope',  'localizationService', 'queryControllerData', 'csApi',
function($scope, localizationService, queryControllerData, csApi) {

// localization implementaiton in the future
	// $scope.deleteServiceLabel;
	// $scope.removeConfirmationLabel;
	// $scope.cancelLabel;
	// $scope.confirmLabel;
	$scope.entitySelected = queryControllerData.tabData.node.entityString;
        
        //if last character is a space, removes the space
        if($scope.entitySelected.charAt($scope.entitySelected.length-1) === ' '){
            $scope.entitySelected = $scope.entitySelected.substring(0, $scope.entitySelected.length-1);
        }

	$scope.cancel = function(){
	    $scope.$close();
	};

	$scope.confirm = function(){
		csApi.deleteService('/genesys/1/cs', queryControllerData.tabData.node.service_id).then(function(httpResponse){
			queryControllerData.addHttpRequestHistory(httpResponse, 'Delete Service: ' + queryControllerData.tabData.node.service_id);
			$scope.$close();
			queryControllerData.tabData.node = undefined;
			queryControllerData.tabData.taskAddable = false;
			queryControllerData.tabData.stateAddable = false;
			queryControllerData.queryType = queryControllerData.tabData.oldQueryType;
			queryControllerData.customerId = queryControllerData.tabData.oldCustomerId;
			queryControllerData.tabData.queryById();
		}, function(errResponse){
			queryControllerData.addHttpRequestHistory(errResponse, 'Delete Service: ' + queryControllerData.tabData.node.service_id);
		})
	};
}]);
