'use strict';

angular.module('cs.query').directive('propertylist', function() {
    return {
        templateUrl: 'app/modules/context-services/properties.html',
        restrict: 'E',
        transclude: 'true',
        link: function(scope) {
            scope.addInput = function() {
                scope.inputNumber++;
                scope.propertyInputs.push('add');
            };
            scope.removeInput = function() {
                scope.inputNumber--;
                scope.propertyInputs.pop();
                scope.usedProperties.pop();
            };
            if (scope.parentData) {
                scope.tabData = scope.parentData;
            }
            scope.addInput();
            scope.$watchCollection(function() {
                return scope.usedProperties;
            }, function(usedProperties) {
                if (usedProperties[scope.inputNumber - 1] && scope.propertyInputs.length < scope.properties.length - 1) {
                    scope.addInput();
                } else if (!usedProperties[scope.inputNumber - 2] && usedProperties.length > 0) {
                    scope.removeInput();
                }
            });

            scope.getMediaTypeKeys = function(property) {
                var key, mediaKeys = [];
                for (key in scope.tabData.mediaAttributes[property]) {
                    mediaKeys.push(key);
                }
                return mediaKeys;
            };
            scope.getDispositionTypeKeys = function(property) {
                var key, dispositionKeys = [];
                for (key in scope.tabData.dispositionAttributes[property]) {
                    dispositionKeys.push(key);
                }
                return dispositionKeys;
            };
            scope.getApplicationTypeKeys = function(property) {
                var key, applicationKeys = [];
                for (key in scope.tabData.applicationAttributes[property]) {
                    applicationKeys.push(key);
                }
                return applicationKeys;
            };
            scope.getResourceTypeKeys = function(property) {
                var key, resourceKeys = [];
                for (key in scope.tabData.resourceAttributes[property]) {
                    resourceKeys.push(key);
                }
                return resourceKeys;
            };
            scope.getPropertyKeys = function(property) {
                var key, propertyKeys = [];
                for (key in scope.tabData.propertyAttributes[(scope.panelId ? scope.panelId : scope.tabData.node.type) + '.' + property]) {
                    propertyKeys.push(key);
                }
                return propertyKeys;
            };

            scope.getPropertyAttribute = function(property) {
                return scope.tabData.propertyAttributes[(scope.panelId ? scope.panelId : scope.tabData.node.type) + '.' + property];
            };
        }
    };
})

.directive('csDatepicker', function() {
    return {
        templateUrl: 'app/modules/context-services/datepicker.html',
        restrict: 'E',
        scope: {
            model: '='
        },
        transclude: 'true',
        link: function(scope) {
            scope.maxDate = new Date();
            scope.open = function($event) {
                $event.preventDefault();
                $event.stopPropagation();
                scope.opened = true;
            };
        }
    };
})

//query filters
.filter('excludeUsed', function() {
    return function(input, scope) {
        var i,
            j,
            output = [],
            used;

        for (i = 0; i < input.length; i++) {
            used = false;
            if (input[i] === '' && (scope.$last)) {
                used = true;
            } else {
                for (j = 0; j <= scope.$index; j++) {
                    if (input[i] === scope.usedProperties[j] && j !== scope.$index) {
                        used = true;
                        break;
                    }
                }
            }
            if (!used) {
                output.push(input[i]);
            }
        }
        return output;
    };
});
