'use strict';

angular.module('cs.dashboard.timelineLink', []).controller('TimelineController', function($scope, csUtils){
	$scope.journeyStats.selectedAService = false; 
	$scope.journeyStats.activeJourneys = 0; 
	$scope.journeyStats.nbJourneys = 0 ; 
	$scope.journeyStats.completedJourneys = 0 ; 
	$scope.journeyStats.average = "Cannot calculate";
	
	if ($scope.tabData.node && $scope.tabData.node.type === 'Service'){
		$scope.timelineServiceId = $scope.tabData.node.service_id;
	}
	
	$scope.selectService = function(serviceInfo){
		if (!serviceInfo){
			$scope.timelineServiceId = undefined;
			return;
		}
		$scope.timelineServiceId = serviceInfo.text;
		if ($scope.tabData.data.hideChildren){
			for (var i = 0; i < $scope.tabData.data.hideChildren.length; i++){
				if ($scope.tabData.data.hideChildren[i].service_id === $scope.timelineServiceId){
					csUtils.updateNode($scope.tabData.data.hideChildren[i], $scope.tabData);
					$scope.journeyStats.updateDetails($scope.tabData.data.hideChildren[i]);

					return;
				}
			}
		}
		if ($scope.tabData.data.children){
			for (var i = 0; i < $scope.tabData.data.children.length; i++){
				$scope.tabData.data.hideChildren[i].isSelected = false;
				if ($scope.tabData.data.children[i].service_id === $scope.timelineServiceId){
					csUtils.updateNode($scope.tabData.data.children[i], $scope.tabData);
					$scope.journeyStats.updateDetails($scope.tabData.data.children[i]);
					return;
				}
			}
		}
	}
})