﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows.Media;
using Genesyslab.Desktop.Modules.Core;
using Genesyslab.Desktop.Modules.OpenMedia.Model.Interactions;

namespace Genesyslab.Desktop.Modules.CustomWorkItemSample.Windows.ContentView
{
	public class CustomWorkItemViewModel : ICustomWorkItemViewModel, INotifyPropertyChanged
	{
		public CustomWorkItemViewModel()
		{
		}

		#region ICustomWorkItemViewModel Members

		IInteractionOpenMedia interaction;
		public IInteractionOpenMedia Interaction
		{
			get { return interaction; }
			set { if (interaction != value) { interaction = value; OnPropertyChanged("Interaction"); } }
		}

		bool isItPossibleToMyButton = true;
		public bool IsItPossibleToMyButton
		{
			get { return isItPossibleToMyButton; }
			protected set { if (isItPossibleToMyButton != value) { isItPossibleToMyButton = value; OnPropertyChanged("IsItPossibleToMyButton"); } }
		}

		#endregion

		#region INotifyPropertyChanged Members

		public event PropertyChangedEventHandler PropertyChanged;
		private void OnPropertyChanged(string propertyName)
		{
			if (PropertyChanged != null)
				PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
		}

		#endregion
	}
}
