﻿using System;
using System.Windows.Controls;
using Microsoft.Practices.Composite.Regions;
using System.Collections.Generic;
using Genesyslab.Desktop.Modules.Core.Model.Interactions;
using Genesyslab.Desktop.Infrastructure;
using Genesyslab.Desktop.Modules.OpenMedia.Model.Interactions;
using Genesyslab.Desktop.WPFCommon;
using Microsoft.Practices.Unity;
using Genesyslab.Desktop.Infrastructure.Commands;

namespace Genesyslab.Desktop.Modules.CustomWorkItemSample.Windows.ToolBarView
{
	/// <summary>
	/// Interaction logic for CustomWorkItemToolBarView.xaml
	/// </summary>
	public partial class CustomWorkItemToolBarView : UserControl, ICustomWorkItemToolBarView
	{
		IUnityContainer container;

		public CustomWorkItemToolBarView(IUnityContainer container,ICustomWorkItemToolBarViewModel customWorkItemToolBarViewModel)
		{
			this.container = container;
			Model = customWorkItemToolBarViewModel;

			InitializeComponent();

			Width = Double.NaN;
			Height = Double.NaN;
		}

		#region IView Members

		public object Context { get; set; }

		public IRegionManager RegionManager { get; set; }

		public void Create()
		{
			IDictionary<string, object> contextDictionary = Context as IDictionary<string, object>;
			Model.Interaction = contextDictionary.TryGetValue("Interaction") as IInteractionOpenMedia;
		}

		public void Destroy()
		{
		}

		#endregion

		#region ICustomWorkItemToolBarView Members

		public ICustomWorkItemToolBarViewModel Model
		{
			get { return this.DataContext as ICustomWorkItemToolBarViewModel; }
			set { this.DataContext = value; }
		}

		#endregion

		private void StopProcessingButton_Click(object sender, System.Windows.RoutedEventArgs e)
		{

			IChainOfCommand Command = container.Resolve<ICommandManager>().GetChainOfCommandByName("InteractionCustomWorkitemStopProcessing");

			Utils.ExecuteAsynchronousCommand(Command,
						   new Dictionary<string, object>() { { "CommandParameter", Model.Interaction } },
						   StopProcessingButton);
		}
	}
}
