﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
using Genesyslab.Desktop.Modules.OpenMedia.Model.Interactions;

namespace Genesyslab.Desktop.Modules.CustomWorkItemSample.Windows.ToolBarView
{
	public class CustomWorkItemToolBarViewModel : ICustomWorkItemToolBarViewModel, INotifyPropertyChanged
	{

		public CustomWorkItemToolBarViewModel()
		{
		}

		#region ICustomWorkItemToolBarViewModel Members

		
		IInteractionOpenMedia interaction;
		public IInteractionOpenMedia Interaction
		{
			get { return interaction; }
			set { if (interaction != value) { interaction = value; OnPropertyChanged("Interaction"); } }
		}

		#endregion

		#region INotifyPropertyChanged Members

		public event PropertyChangedEventHandler PropertyChanged;
		private void OnPropertyChanged(string propertyName)
		{
			if (PropertyChanged != null)
				PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
		}

		#endregion
	}
}
