using Genesyslab.Desktop.Infrastructure.Commands;
using Genesyslab.Desktop.Infrastructure.DependencyInjection;
using Genesyslab.Desktop.Infrastructure.ViewManager;
using Genesyslab.Desktop.Modules.ExtensionSample.CustomCommand;
using Genesyslab.Desktop.Modules.ExtensionSample.DispositionCodeEx;
using Genesyslab.Desktop.Modules.ExtensionSample.MySample;
using Genesyslab.Desktop.Modules.Windows.Views.Interactions.CaseView.DispositionCodeView;
//using Microsoft.Practices.Composite.Modularity;
using Genesyslab.Desktop.Infrastructure;
using Genesyslab.Desktop.Modules.Windows.Event;
using System.Windows;

namespace Genesyslab.Desktop.Modules.ExtensionSample
{
	/// <summary>
	/// This class is a sample module which shows several ways of customization
	/// </summary>
	public class ExtensionSampleModule : IModule
	{
		readonly IObjectContainer container;
		readonly IViewManager viewManager;
		readonly ICommandManager commandManager;
		readonly IViewEventManager viewEventManager;

		/// <summary>
		/// Initializes a new instance of the <see cref="ExtensionSampleModule"/> class.
		/// </summary>
		/// <param name="container">The container.</param>
		/// <param name="viewManager">The view manager.</param>
		/// <param name="commandManager">The command manager.</param>
		public ExtensionSampleModule(IObjectContainer container, IViewManager viewManager, ICommandManager commandManager, IViewEventManager viewEventManager)
		{
			this.container = container;
			this.viewManager = viewManager;
			this.commandManager = commandManager;
			this.viewEventManager = viewEventManager;
		}

		/// <summary>
		/// Initializes the module.
		/// </summary>
		public void Initialize()
		{
			///////////////////////
			// GUI customization case 1
			// Replacing an already existing view "DispositionCodeView" in the Interaction Voice (not the behavior)

			// Associate the existing "IDispositionCodeView" with the new "DispositionCodeExView" implementation
			container.RegisterType<IDispositionCodeView, DispositionCodeExView>();


			///////////////////////
			// GUI customization case 2
			// Add a view in the workspace in the main tool bar

			// Here we register the view (GUI) "IMySampleView" and its behavior counterpart "IMySamplePresentationModel"
			container.RegisterType<IMySampleView, MySampleView>();
			container.RegisterType<IMySampleViewModel, MySampleViewModel>();

			// Put the MySample view in the region "ToolbarWorkplaceRegion" (The TabControl in the main toolbar)
			viewManager.ViewsByRegionName["ToolbarWorkplaceRegion"].Insert(0,
				new ViewActivator() { ViewType = typeof(IMySampleView), ViewName = "MySample" });

			// Here we register the view (GUI) "IMySampleMenuView"
			container.RegisterType<IMySampleMenuView, MySampleMenuView>();

			// Put the MySampleMenuView view in the region "WorkspaceMenuRegion" (The Workspace toggle button in the main toolbar)
			viewManager.ViewsByRegionName["WorkspaceMenuRegion"].Insert(0,
				new ViewActivator() { ViewType = typeof(IMySampleMenuView), ViewName = "MySampleMenu", ActivateView = true });


			///////////////////////
			// Command customization
			// Add a command before the release call
			commandManager.CommandsByName["InteractionVoiceReleaseCall"].Insert(0,
				new CommandActivator() { CommandType = typeof(BeforeReleaseCallCommand) });


			///////////////////////
			// Event registration
			// Subscribe to the post login / post logout events
			viewEventManager.Subscribe(MyEventHandler);
		}

		void MyEventHandler(object eventObject)
		{
			string eventMessage = eventObject as string;
			if (eventMessage != null)
			{
				switch (eventMessage)
				{
					case "Loggin":
						MessageBox.Show("Post logged in");
						break;
					case "Logout":
						MessageBox.Show("Post logged out");
						viewEventManager.Unsubscribe(MyEventHandler);
						break;
				}
			}
		}

	}
}
