﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using Genesyslab.Desktop.Modules.OpenMedia.Model.Interactions;
using Genesyslab.Desktop.WPFCommon.Controls;

namespace Genesyslab.Desktop.Modules.CustomWorkItemSample.Windows.ToolBarView
{
	public class CustomWorkItemToolBarViewModel : ICustomWorkItemToolBarViewModel, INotifyPropertyChanged
	{

		public CustomWorkItemToolBarViewModel()
		{
		}

		#region ICustomWorkItemToolBarViewModel Members

		
		IInteractionOpenMedia interaction;
		public IInteractionOpenMedia Interaction
		{
			get { return interaction; }
			set { if (interaction != value) { interaction = value; OnPropertyChanged("Interaction"); } }
		}

		#endregion

		ButtonStyle buttonStyle;
		public ButtonStyle ButtonStyle
		{
			get { return buttonStyle; }
			set
			{
				if (buttonStyle != value)
				{
					buttonStyle = value;
					OnPropertyChanged("ButtonStyle");
				}
			}
		}

		#region INotifyPropertyChanged Members

		public event PropertyChangedEventHandler PropertyChanged;
		private void OnPropertyChanged(string propertyName)
		{
			if (PropertyChanged != null)
				PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
		}

		#endregion
	}
}
