﻿using System.Collections.Generic;
using System.Windows;
using Genesyslab.Desktop.Infrastructure.Commands;
using Genesyslab.Platform.Commons.Logging;
using Microsoft.Practices.Composite.Wpf.Commands;
using Microsoft.Practices.Unity;

namespace Genesyslab.Desktop.Modules.InteractionManagementExtensionSample
{
    public class ChooseReasonWindowModel : IChooseReasonWindowModel
    {
        DelegateCommand<object> applyCommand;
        DelegateCommand<object> cancelCommand;

        readonly IUnityContainer container;
        readonly ILogger log;

        string markDoneReason = "DeleteConversation";

        public ChooseReasonWindowModel(IUnityContainer container, ILogger logger)
        {
            applyCommand = new DelegateCommand<object>(ApplyCommandHandler);
            cancelCommand = new DelegateCommand<object>(CancelCommandHandler);
            this.container = container;
            this.log = logger.CreateChildLogger("ChooseReasonWindowModel");
            this.log.Debug("ChooseReasonWindowModel");
        }

        void ApplyCommandHandler(object parameter)
        {
            SaveReason();
            Window chooseReasonWindow = parameter as Window;
            if (chooseReasonWindow != null)
                chooseReasonWindow.Close();
        }

        void CancelCommandHandler(object parameter)
        {
            Window chooseReasonWindow = parameter as Window;
            if (chooseReasonWindow != null)
                chooseReasonWindow.Close();
        }

        void SaveReason()
        {
            string selectedReason = markDoneReason;

            if (InteractionIds != null && InteractionIds.Count > 0)
            {
                IChainOfCommand multipleSetAttachedData = container.Resolve<ICommandManager>().GetChainOfCommandByName("MultipleInteractionsActionFromWorkbinById");
                Dictionary<string, object> parameters = new Dictionary<string, object>();
                parameters.Add("BasicActionNameDicoId", "InteractionManagement.MenuItemInteractionActionMarkDoneWithReason");
                parameters.Add("SingleActionChainOfCommandName", "InteractionManagementMarkDoneWithReason");
                //parameters.Add("DoNotAutoRefreshInteractionsList", "true");
                parameters.Add("MarkDoneReason", selectedReason);
                //parameters.Add("WorkbinsView", WorkbinsView);
                parameters.Add("nbInteractions", InteractionIds.Count);
                for(int i=0; i<InteractionIds.Count; i++)
                {
                    parameters.Add("interactionId" + i, InteractionIds[i]);
                    //parameters.Add("mediaType" + i, InteractionMediaTypes[i]);
                }
                multipleSetAttachedData.Execute(parameters);
            }
        }


        #region IChooseReasonWindowModel Members

        public IList<string> InteractionIds { get; set; }

        //public IList<string> InteractionMediaTypes { get; set; }

        //public object WorkbinsView { get; set; }

        public void SetMarkDoneReason(string newMarkDoneReason)
        {
            markDoneReason = newMarkDoneReason;
        }

        public DelegateCommand<object> CancelCommand { get { return cancelCommand; } }
        public DelegateCommand<object> ApplyCommand { get { return applyCommand; } }

        #endregion

    }
}
