using System.Collections.Generic;
using Genesyslab.Desktop.Infrastructure;
using Genesyslab.Desktop.Infrastructure.Commands;
using Genesyslab.Desktop.Infrastructure.ViewManager;
using Genesyslab.Desktop.Modules.OpenMedia.Model.Interactions;
using Genesyslab.Desktop.Modules.Windows.Interactions;
using Microsoft.Practices.Unity;

namespace Genesyslab.Desktop.Modules.InteractionManagementExtensionSample
{
	/// <summary>
	/// This class is a sample module which shows several ways of customization
	/// </summary>
	public class InteractionManagementExtensionSampleModule : IModule
	{
        readonly IUnityContainer container;
		readonly IViewManager viewManager;
		readonly ICommandManager commandManager;

		/// <summary>
		/// Initializes a new instance of the <see cref="InteractionManagementExtensionSampleModule"/> class.
		/// </summary>
		/// <param name="container">The container.</param>
		/// <param name="viewManager">The view manager.</param>
		/// <param name="commandManager">The command manager.</param>
        public InteractionManagementExtensionSampleModule(IUnityContainer container, IViewManager viewManager, ICommandManager commandManager)
		{
			this.container = container;
			this.viewManager = viewManager;
			this.commandManager = commandManager;
		}

		/// <summary>
		/// Initializes the module.
		/// </summary>
		public void Initialize()
		{
            // Classes
            container.RegisterType<IInteractionControlExtension, InteractionManagementControlExtensionSample>("InteractionManagementControl", new ContainerControlledLifetimeManager());

            container.RegisterType<IChooseReasonWindowModel, ChooseReasonWindowModel>();
            container.RegisterType<IChooseReasonWindow, ChooseReasonWindow>();

            container.RegisterType<IInteractionManagerInteractionOpenMediaExtension, InteractionManagerInteractionExtensionSample>("InteractionManagerInteractionExtensionSample", new ContainerControlledLifetimeManager());

            // Views and Regions
            viewManager.AddViewsToRegion("ChooseReasonRegion", new List<ViewActivator>()
			{
			    new	ViewActivator() { ViewType = typeof(IChooseReasonWindow), ActivateView = true, ViewName = "ChooseReasonView", CreateNewRegionManager = true, DynamicOnly = true }
			});


            // Chain of commands
            commandManager.AddCommandToChainOfCommand("InteractionManagementMarkDoneWithReason", new List<CommandActivator>()
            {
                new CommandActivator() { CommandType = typeof(InteractionManagementMarkDoneWithReasonCommand), Name="MarkDoncWithReason" }
            });

            commandManager.AddCommandToChainOfCommand("SetReasonAndStopProcessing", new List<CommandActivator>()
            {
                new CommandActivator() { CommandType = typeof(InteractionOpenMediaEsdkSetReasonCommand), Name = "EsdkSetReason"},
                new CommandActivator() { CommandType = typeof(InteractionOpenMediaEsdkStopProcessingCommand), Name = "EsdkStopProcessing"},
            });
        }
	}
}
